/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.metrics.listeners;

import io.wizzie.metrics.listeners.MetricListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaMetricListener
implements MetricListener {
    public static final String METRIC_KAFKA_TOPIC = "metric.kafka.topic";
    KafkaProducer<String, Map<String, Object>> kafkaProducer;
    Map<String, Object> metricDataBag;
    String topic;
    String appId;

    @Override
    public void init(Map<String, Object> config) {
        this.appId = (String)config.getOrDefault("application.id", Thread.currentThread().getName());
        this.topic = (String)config.getOrDefault(METRIC_KAFKA_TOPIC, "__metrics");
        this.metricDataBag = (Map)config.get("metric.databag");
        config.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        config.put("value.serializer", "io.wizzie.metrics.listeners.JsonSerializer");
        this.kafkaProducer = new KafkaProducer(config);
    }

    @Override
    public void updateMetric(String metricName, Object metricValue) {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("timestamp", System.currentTimeMillis() / 1000L);
        metric.put("monitor", metricName);
        metric.put("value", metricValue);
        metric.put("app_id", this.appId);
        if (this.metricDataBag != null) {
            metric.putAll(this.metricDataBag);
        }
        if (metricValue != null) {
            this.kafkaProducer.send(new ProducerRecord(this.topic, (Object)this.appId, metric));
        }
    }

    @Override
    public void close() {
        this.kafkaProducer.flush();
        this.kafkaProducer.close();
    }

    @Override
    public String name() {
        return "kafka";
    }
}

