/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.query.antlr4;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.enricher.query.antlr4.Stream;
import java.util.Collections;
import java.util.List;

public class Join {
    List<String> dimensions;
    Stream topic;
    String joinerName;
    String partitionKey;

    public Join(Stream topic, String joinerName) {
        this(topic, joinerName, Collections.EMPTY_LIST);
    }

    public Join(Stream topic, String joinerName, List<String> dimensions) {
        this(topic, joinerName, dimensions, "__KEY");
    }

    public Join(Stream topic, String joinerName, List<String> dimensions, String partitionKey) {
        this.topic = (Stream)Preconditions.checkNotNull((Object)topic, (Object)"<topic> attribute is required");
        this.joinerName = (String)Preconditions.checkNotNull((Object)joinerName, (Object)"<joinerName> attribute is required");
        this.dimensions = (List)Preconditions.checkNotNull(dimensions, (Object)"<dimensions> is required");
        this.partitionKey = (String)Preconditions.checkNotNull((Object)partitionKey, (Object)"<partitionKey> is required");
    }

    public void setStream(Stream stream) {
        this.topic = stream;
    }

    public Stream getStream() {
        return this.topic;
    }

    public void setDimensions(List<String> newDimensions) {
        this.dimensions = newDimensions;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public void setJoinerName(String newClassName) {
        this.joinerName = newClassName;
    }

    public String getJoinerName() {
        return this.joinerName;
    }

    public void setPartitionKey(String newPartitionKey) {
        this.partitionKey = newPartitionKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void validate() {
        Preconditions.checkNotNull(this.dimensions, (Object)"At least a dimensions list is required");
        Preconditions.checkNotNull((Object)this.topic, (Object)"At least a topic is required");
        Preconditions.checkNotNull((Object)this.joinerName, (Object)"At least a joiner class name is required");
        this.topic.validate();
    }
}

