/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.bootstrapper.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Config {
    Map<String, Object> config = new HashMap<String, Object>();
    Properties properties = new Properties();

    public Config() {
    }

    public Config(Map<String, Object> properties) {
        this.init(properties);
    }

    public Config(String configPath) throws IOException {
        this.init(configPath);
    }

    public Config(String configPath, Map<String, Object> properties) throws IOException {
        if (configPath != null) {
            this.init(configPath);
        }
        if (properties != null) {
            this.init(properties);
        }
    }

    private void init(String configPath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        this.init((Map)objectMapper.readValue(new File(configPath), Map.class));
    }

    private void init(Map<String, Object> mapProperties) {
        this.config.putAll(mapProperties);
        this.properties.putAll(mapProperties);
    }

    public <T> T get(String property) {
        Object ret = null;
        if (this.config != null) {
            ret = this.config.get(property);
        }
        return (T)ret;
    }

    public <T> T getOrDefault(String property, T defaultValue) {
        Object ret = null;
        ret = this.config != null && this.config.get(property) != null ? this.config.get(property) : (Object)defaultValue;
        return (T)ret;
    }

    public Config put(String property, Object value) {
        this.config.put(property, value);
        this.properties.put(property, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, Object> getMapConf() {
        return this.config;
    }

    public Config clone() {
        return new Config(new HashMap<String, Object>(this.config));
    }
}

