/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.amazonaws.services.logs.model.InputLogEvent;
import io.wisetime.wise_log_aws.cloud.CloudWriter;
import io.wisetime.wise_log_aws.cloud.ConfigPojo;
import io.wisetime.wise_log_aws.cloud.LayoutEngineJson;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class WiseAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final ConfigPojo.ConfigPojoBuilder configBuilder = ConfigPojo.ConfigPojoBuilder.aConfigPojo();
    private final LayoutEngineJson layoutEngine = new LayoutEngineJson();
    private ScheduledExecutorService scheduledExecutor;
    private CloudWriter cloudWriter = null;
    private AtomicBoolean initialised = new AtomicBoolean(false);

    public void start() {
        this.layoutEngine.start();
        super.start();
    }

    void flushLogs() {
        if (this.cloudWriter != null) {
            try {
                this.cloudWriter.processLogEntries();
            }
            catch (Exception e) {
                System.err.println("AWS lib internal error " + e);
                this.addWarn("Internal error", e);
            }
        }
    }

    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        if (!this.initialised.get()) {
            this.runInit();
        }
        if (this.cloudWriter != null) {
            InputLogEvent msg = new InputLogEvent();
            msg.setTimestamp(Long.valueOf(eventObject.getTimeStamp()));
            String jsonStr = this.layoutEngine.doLayout(eventObject);
            msg.setMessage(jsonStr);
            this.cloudWriter.addMessageToQueue(msg);
        }
    }

    private synchronized void runInit() {
        if (this.initialised.compareAndSet(false, true)) {
            ThreadFactory threadFactory = r -> {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("wise-log-" + UUID.randomUUID().toString().substring(0, 7));
                thread.setDaemon(true);
                return thread;
            };
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            ConfigPojo configPojo = this.configBuilder.build();
            Optional<CloudWriter> cloudWriterOpt = this.getOrCreateLogWriter(configPojo);
            cloudWriterOpt.ifPresent(writer -> {
                this.cloudWriter = writer;
                this.scheduledExecutor.scheduleWithFixedDelay(this::flushLogs, configPojo.getFlushIntervalInSeconds(), configPojo.getFlushIntervalInSeconds(), TimeUnit.SECONDS);
                this.layoutEngine.addConfig(configPojo, this.cloudWriter.getConfigPropertyMap());
            });
        }
    }

    private Optional<CloudWriter> getOrCreateLogWriter(ConfigPojo configPojo) {
        return this.cloudWriter == null ? CloudWriter.createWriter(configPojo) : Optional.of(this.cloudWriter);
    }

    public void stop() {
        if (this.cloudWriter != null) {
            this.scheduledExecutor.shutdown();
            try {
                this.scheduledExecutor.awaitTermination(6 * this.configBuilder.build().getFlushIntervalInSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.addWarn("Exception waiting for termination of scheduler", e);
            }
            this.flushLogs();
            this.cloudWriter.stop();
        }
        super.stop();
    }

    public void setFlushIntervalInSeconds(int flushIntervalInSeconds) {
        this.configBuilder.withFlushIntervalInSeconds(flushIntervalInSeconds);
    }

    @Deprecated
    public void setLogDefaultGroup(String logGroup) {
        this.configBuilder.withDefaultLogGroup(logGroup);
    }

    public void setLogGroup(String logGroup) {
        this.configBuilder.withDefaultLogGroup(logGroup);
    }

    public void setModuleName(String moduleName) {
        this.configBuilder.withModuleName(moduleName);
    }

    public void setEnabled(String enabledStr) {
        this.configBuilder.withEnabled(enabledStr);
    }

    public void setPropertiesFilePath(String propertiesFilePath) {
        this.configBuilder.withPropertiesFilePath(propertiesFilePath);
    }

    public ConfigPojo getConfigPojo() {
        return this.configBuilder.build();
    }

    void reEnableForTest() {
        this.initialised.set(false);
    }

    void setLogsWriter(CloudWriter logsWriter) {
        this.cloudWriter = logsWriter;
    }
}

