/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ThresholdFilterWithExclusion
extends ThresholdFilter {
    private List<String> excludedLogPrefixList = new ArrayList<String>();

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (event == null || event.getLevel() == null) {
            return FilterReply.NEUTRAL;
        }
        FilterReply threshholdResult = super.decide(event);
        if (threshholdResult == FilterReply.DENY && this.isExcludedPackagePrefix(event.getLoggerName())) {
            return FilterReply.NEUTRAL;
        }
        return threshholdResult;
    }

    private boolean isExcludedPackagePrefix(String loggerName) {
        if (loggerName == null) {
            return false;
        }
        String logNameLower = loggerName.toLowerCase();
        return this.excludedLogPrefixList.stream().anyMatch(logNameLower::startsWith);
    }

    public void setExcludedLogPrefixList(String excludedPrefixTsv) {
        this.excludedLogPrefixList = new ArrayList<String>();
        if (excludedPrefixTsv == null) {
            return;
        }
        String tsvList = excludedPrefixTsv.trim();
        if ((tsvList = tsvList.replaceAll("\\s+", "")).isEmpty()) {
            return;
        }
        String[] packageNames = tsvList.split(";");
        if (packageNames.length == 0) {
            return;
        }
        this.excludedLogPrefixList = Arrays.stream(packageNames).map(String::toLowerCase).collect(Collectors.toList());
    }
}

