/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import java.util.Optional;

class ConfigPojo {
    private String region;
    private String moduleName;
    private String logGroupName;
    private String propertiesFilePath;
    private boolean enabled = true;
    private int flushIntervalInSeconds = 4;

    ConfigPojo() {
    }

    int getFlushIntervalInSeconds() {
        return this.flushIntervalInSeconds;
    }

    Optional<String> getModuleName() {
        return Optional.ofNullable(this.moduleName);
    }

    Optional<String> getLogGroupName() {
        return Optional.ofNullable(this.logGroupName);
    }

    Optional<String> getPropertiesFilePath() {
        return Optional.ofNullable(this.propertiesFilePath);
    }

    Optional<String> getRegion() {
        return Optional.ofNullable(this.region);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    static final class ConfigPojoBuilder {
        private int flushIntervalInSeconds = 3;
        private String moduleName;
        private String defaultLogGroup;
        private String region;
        private String propertiesFilePath;
        private boolean enabled = true;

        private ConfigPojoBuilder() {
        }

        public static ConfigPojoBuilder aConfigPojo() {
            return new ConfigPojoBuilder();
        }

        public ConfigPojoBuilder withFlushIntervalInSeconds(int flushIntervalInSeconds) {
            this.flushIntervalInSeconds = flushIntervalInSeconds;
            return this;
        }

        public ConfigPojoBuilder withDefaultLogGroup(String defaultLogGroup) {
            this.defaultLogGroup = defaultLogGroup;
            return this;
        }

        public ConfigPojoBuilder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ConfigPojoBuilder withPropertiesFilePath(String propertiesFilePath) {
            this.propertiesFilePath = propertiesFilePath;
            return this;
        }

        public ConfigPojoBuilder withEnabled(String enabledStr) {
            this.enabled = !"false".equalsIgnoreCase(enabledStr);
            return this;
        }

        public ConfigPojoBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public ConfigPojo build() {
            ConfigPojo configPojo = new ConfigPojo();
            configPojo.moduleName = this.moduleName;
            configPojo.logGroupName = this.defaultLogGroup;
            configPojo.flushIntervalInSeconds = this.flushIntervalInSeconds;
            configPojo.enabled = this.enabled;
            configPojo.propertiesFilePath = this.propertiesFilePath;
            configPojo.region = this.region;
            return configPojo;
        }
    }
}

