/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.logs.AWSLogsAsync;
import com.amazonaws.services.logs.AWSLogsAsyncClientBuilder;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceNotFoundException;
import io.wisetime.wise_log_aws.cloud.ConfigPojo;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

class CloudWriter {
    private final ConcurrentLinkedQueue<InputLogEvent> messageQueue = new ConcurrentLinkedQueue();
    private final Map<String, String> configPropertyMap;
    private final AWSLogsAsync awsLog;
    private final String logGroupName;
    private final String logStreamName;
    private String cloudWatchNextSequenceToken;

    private CloudWriter(AWSLogsAsync awsLog, String logGroupName, String logStreamName, Map<String, String> configPropertyMap) {
        this.awsLog = awsLog;
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.configPropertyMap = configPropertyMap;
    }

    void processLogEntries() {
        boolean sentLimit;
        while (sentLimit = this.processToLimit()) {
        }
    }

    void stop() {
        try {
            this.awsLog.shutdown();
        }
        catch (Exception e) {
            System.out.println("Shutdown issue with cloud writer " + e.getMessage());
        }
    }

    private boolean processToLimit() {
        AtomicBoolean limitReached = new AtomicBoolean(false);
        List<InputLogEvent> eventList = this.createListFromQueue(limitReached);
        if (!eventList.isEmpty()) {
            List eventListSorted = eventList.stream().sorted(Comparator.comparingLong(InputLogEvent::getTimestamp)).collect(Collectors.toList());
            PutLogEventsResult result = this.awsLog.putLogEvents(new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withLogEvents(eventListSorted).withSequenceToken(this.cloudWatchNextSequenceToken));
            this.cloudWatchNextSequenceToken = result.getNextSequenceToken();
        }
        return limitReached.get();
    }

    private List<InputLogEvent> createListFromQueue(AtomicBoolean limitReached) {
        InputLogEvent logEvent;
        ArrayList<InputLogEvent> eventList = new ArrayList<InputLogEvent>();
        int maxLogEvents = 8000;
        AtomicInteger byteCount = new AtomicInteger();
        while ((logEvent = this.messageQueue.poll()) != null) {
            int MAX_AWS_PUT_SIZE;
            if (logEvent.getMessage() == null) continue;
            eventList.add(logEvent);
            if (eventList.size() >= 8000) {
                limitReached.set(true);
                return eventList;
            }
            int logBundleSize = byteCount.addAndGet(logEvent.getMessage().getBytes(StandardCharsets.UTF_8).length + 26);
            if (logBundleSize <= (MAX_AWS_PUT_SIZE = 1000576)) continue;
            limitReached.set(true);
            return eventList;
        }
        return eventList;
    }

    Map<String, String> getConfigPropertyMap() {
        return this.configPropertyMap;
    }

    void addMessageToQueue(InputLogEvent msg) {
        this.messageQueue.offer(msg);
    }

    static Optional<CloudWriter> createWriter(ConfigPojo configPojo) {
        try {
            HashMap<String, String> configPropertyMap = new HashMap<String, String>();
            Optional<AWSCredentials> awsCredentials = CloudWriter.lookupCredentials();
            if (!awsCredentials.isPresent()) {
                System.err.println("AWS credentials not found, AWS logger disabled");
                return Optional.empty();
            }
            configPropertyMap.put("accessKeyId", awsCredentials.get().getAWSAccessKeyId());
            AWSLogsAsyncClientBuilder builder = AWSLogsAsyncClientBuilder.standard();
            configPojo.getRegion().ifPresent(regionStr -> {
                Region regionObj = RegionUtils.getRegion((String)regionStr);
                if (regionObj == null) {
                    System.err.println(String.format("Could not find region information for '%s' in SDK metadata.", regionStr));
                } else {
                    builder.withRegion(regionObj.getName());
                }
            });
            AWSLogsAsync awsLog = (AWSLogsAsync)builder.build();
            CloudWriter.addAWSFileProperties(configPropertyMap);
            configPojo.getPropertiesFilePath().ifPresent(filePath -> configPropertyMap.putAll(CloudWriter.addUserPropertyFile(filePath)));
            String logGroupName = configPojo.getLogGroupName().orElseGet(() -> (String)configPropertyMap.get("log_group_name"));
            if (logGroupName == null) {
                System.err.println("Log group name is not defined, please set <logGroup> in WiseAppender config or via <propertiesFilePath>");
                return Optional.empty();
            }
            String logStreamName = String.format("module-%s/%s", configPojo.getModuleName().orElse("unknown"), UUID.randomUUID().toString());
            try {
                awsLog.createLogStream(new CreateLogStreamRequest().withLogGroupName(logGroupName).withLogStreamName(logStreamName));
                System.err.println("Streaming logs to group: " + logGroupName + ", stream: " + logStreamName);
            }
            catch (ResourceNotFoundException ex) {
                System.err.println("Unable to create log stream with a name " + logStreamName + " for a group name " + logGroupName + ".");
                return Optional.empty();
            }
            return Optional.of(new CloudWriter(awsLog, logGroupName, logStreamName, configPropertyMap));
        }
        catch (Throwable t) {
            System.err.println("AWS cloud log writer initialisation failed, msg=" + t.getMessage());
            return Optional.empty();
        }
    }

    static Map<String, String> addUserPropertyFile(String filePath) {
        HashMap<String, String> configMap;
        block15: {
            configMap = new HashMap<String, String>();
            try {
                File propertyFile = new File(filePath);
                if (propertyFile.exists()) {
                    try (FileInputStream input = new FileInputStream(propertyFile);){
                        Properties properties = new Properties();
                        properties.load(input);
                        properties.stringPropertyNames().forEach(propertyKey -> configMap.put((String)propertyKey, properties.getProperty((String)propertyKey)));
                        break block15;
                    }
                }
                System.err.println("propertiesFilePath not found" + filePath);
            }
            catch (Throwable t) {
                System.err.println("propertiesFilePath failed to initialise, msg=" + t.getMessage());
            }
        }
        return configMap;
    }

    private static Optional<AWSCredentials> lookupCredentials() {
        try {
            DefaultAWSCredentialsProviderChain credentialsChain = new DefaultAWSCredentialsProviderChain();
            return Optional.ofNullable(credentialsChain.getCredentials());
        }
        catch (SdkClientException sdkException) {
            return Optional.empty();
        }
    }

    private static void addAWSFileProperties(Map<String, String> configPropertyMap) {
        File awsDir = new File(new File(System.getProperty("user.home")), ".aws");
        File configFile = new File(awsDir, "config");
        if (configFile.exists()) {
            AllProfiles allProfiles = BasicProfileConfigLoader.INSTANCE.loadProfiles(configFile);
            BasicProfile aDefault = allProfiles.getProfile("default");
            if (aDefault != null) {
                aDefault.getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && !((String)entry.getKey()).toLowerCase().contains("secret")).filter(entry -> !"output".equalsIgnoreCase((String)entry.getKey())).filter(entry -> !"region".equalsIgnoreCase((String)entry.getKey())).forEach(entry -> {
                    String cfr_ignored_0 = (String)configPropertyMap.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
                });
            }
        } else {
            System.out.println("Config file " + configFile.getAbsolutePath() + " doesn't exist.");
        }
    }
}

