/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.org.apache.http.impl.conn;

import java.net.InetAddress;
import wise_repack.log.org.apache.http.HttpException;
import wise_repack.log.org.apache.http.HttpHost;
import wise_repack.log.org.apache.http.HttpRequest;
import wise_repack.log.org.apache.http.ProtocolException;
import wise_repack.log.org.apache.http.annotation.Contract;
import wise_repack.log.org.apache.http.annotation.ThreadingBehavior;
import wise_repack.log.org.apache.http.client.config.RequestConfig;
import wise_repack.log.org.apache.http.client.protocol.HttpClientContext;
import wise_repack.log.org.apache.http.conn.SchemePortResolver;
import wise_repack.log.org.apache.http.conn.UnsupportedSchemeException;
import wise_repack.log.org.apache.http.conn.routing.HttpRoute;
import wise_repack.log.org.apache.http.conn.routing.HttpRoutePlanner;
import wise_repack.log.org.apache.http.impl.conn.DefaultSchemePortResolver;
import wise_repack.log.org.apache.http.protocol.HttpContext;
import wise_repack.log.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

