/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.regions;

import java.net.URI;
import wise_repack.log.com.amazonaws.regions.Region;
import wise_repack.log.com.amazonaws.regions.RegionMetadataProvider;

public abstract class AbstractRegionMetadataProvider
implements RegionMetadataProvider {
    @Override
    public Region getRegionByEndpoint(String endpoint) {
        String host = AbstractRegionMetadataProvider.getHost(endpoint);
        for (Region region : this.getRegions()) {
            for (String serviceEndpoint : region.getAvailableEndpoints()) {
                if (!host.equals(AbstractRegionMetadataProvider.getHost(serviceEndpoint))) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    private static String getHost(String endpoint) {
        String host = URI.create(endpoint).getHost();
        if (host == null) {
            host = URI.create("http://" + endpoint).getHost();
        }
        return host;
    }
}

