/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.monitoring;

import wise_repack.log.com.amazonaws.SdkClientException;
import wise_repack.log.com.amazonaws.annotation.ThreadSafe;
import wise_repack.log.com.amazonaws.monitoring.CsmConfiguration;
import wise_repack.log.com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class EnvironmentVariableCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() {
        String enabled = System.getenv("AWS_CSM_ENABLED");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from environment variables!");
        }
        String port = System.getenv("AWS_CSM_PORT");
        String clientId = System.getenv("AWS_CSM_CLIENT_ID");
        clientId = clientId == null ? "" : clientId;
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return new CsmConfiguration(Boolean.parseBoolean(enabled), portNumber, clientId);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from environment variables!", e);
        }
    }
}

