/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.metrics;

import wise_repack.log.com.amazonaws.annotation.NotThreadSafe;
import wise_repack.log.com.amazonaws.metrics.ServiceMetricType;
import wise_repack.log.com.amazonaws.util.TimingInfo;
import wise_repack.log.org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ServiceLatencyProvider {
    private final long startNano;
    private long endNano;
    private final ServiceMetricType serviceMetricType;

    public ServiceLatencyProvider(ServiceMetricType type) {
        this.endNano = this.startNano = System.nanoTime();
        this.serviceMetricType = type;
    }

    public ServiceMetricType getServiceMetricType() {
        return this.serviceMetricType;
    }

    public ServiceLatencyProvider endTiming() {
        if (this.endNano != this.startNano) {
            throw new IllegalStateException();
        }
        this.endNano = System.nanoTime();
        return this;
    }

    public double getDurationMilli() {
        if (this.endNano == this.startNano) {
            LogFactory.getLog(this.getClass()).debug((Object)"Likely to be a missing invocation of endTiming().");
        }
        return TimingInfo.durationMilliOf(this.startNano, this.endNano);
    }

    public String getProviderId() {
        return super.toString();
    }

    public String toString() {
        return String.format("providerId=%s, serviceMetricType=%s, startNano=%d, endNano=%d", this.getProviderId(), this.serviceMetricType, this.startNano, this.endNano);
    }
}

