/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.http.protocol;

import java.io.IOException;
import java.net.Socket;
import wise_repack.log.com.amazonaws.internal.SdkMetricsSocket;
import wise_repack.log.com.amazonaws.internal.SdkSSLMetricsSocket;
import wise_repack.log.com.amazonaws.util.AWSRequestMetrics;
import wise_repack.log.org.apache.http.HttpClientConnection;
import wise_repack.log.org.apache.http.HttpException;
import wise_repack.log.org.apache.http.HttpRequest;
import wise_repack.log.org.apache.http.HttpResponse;
import wise_repack.log.org.apache.http.conn.ManagedHttpClientConnection;
import wise_repack.log.org.apache.http.protocol.HttpContext;
import wise_repack.log.org.apache.http.protocol.HttpRequestExecutor;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (awsRequestMetrics == null) {
            return super.doSendRequest(request, conn, context);
        }
        if (conn instanceof ManagedHttpClientConnection) {
            ManagedHttpClientConnection managedConn = (ManagedHttpClientConnection)conn;
            Socket sock = managedConn.getSocket();
            if (sock instanceof SdkMetricsSocket) {
                SdkMetricsSocket sdkMetricsSocket = (SdkMetricsSocket)sock;
                sdkMetricsSocket.setMetrics(awsRequestMetrics);
            } else if (sock instanceof SdkSSLMetricsSocket) {
                SdkSSLMetricsSocket sdkSSLMetricsSocket = (SdkSSLMetricsSocket)sock;
                sdkSSLMetricsSocket.setMetrics(awsRequestMetrics);
            }
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (awsRequestMetrics == null) {
            return super.doReceiveResponse(request, conn, context);
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

