/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.http.apache.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import wise_repack.log.com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import wise_repack.log.com.amazonaws.util.IOUtils;
import wise_repack.log.org.apache.http.Header;
import wise_repack.log.org.apache.http.HttpEntity;
import wise_repack.log.org.apache.http.HttpException;
import wise_repack.log.org.apache.http.HttpResponse;
import wise_repack.log.org.apache.http.HttpResponseInterceptor;
import wise_repack.log.org.apache.http.entity.HttpEntityWrapper;
import wise_repack.log.org.apache.http.protocol.HttpContext;

public class CRC32ChecksumResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        Header[] headers = response.getHeaders("x-amz-crc32");
        if (entity == null || headers == null || headers.length == 0) {
            return;
        }
        HttpEntityWrapper crc32ResponseEntity = new HttpEntityWrapper(entity){
            private final InputStream content;
            {
                this.content = new CRC32ChecksumCalculatingInputStream(this.wrappedEntity.getContent());
            }

            @Override
            public InputStream getContent() throws IOException {
                return this.content;
            }

            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                try {
                    IOUtils.copy(this.getContent(), outstream);
                }
                finally {
                    this.getContent().close();
                }
            }
        };
        response.setEntity(crc32ResponseEntity);
        context.setAttribute(CRC32ChecksumCalculatingInputStream.class.getName(), crc32ResponseEntity.getContent());
    }
}

