/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.auth.presign;

import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import wise_repack.log.com.amazonaws.AmazonWebServiceRequest;
import wise_repack.log.com.amazonaws.Request;
import wise_repack.log.com.amazonaws.annotation.Immutable;
import wise_repack.log.com.amazonaws.annotation.SdkProtectedApi;
import wise_repack.log.com.amazonaws.auth.AWSCredentialsProvider;
import wise_repack.log.com.amazonaws.auth.Presigner;
import wise_repack.log.com.amazonaws.auth.presign.PresignerParams;
import wise_repack.log.com.amazonaws.internal.auth.SignerProvider;
import wise_repack.log.com.amazonaws.internal.auth.SignerProviderContext;
import wise_repack.log.com.amazonaws.util.CredentialUtils;
import wise_repack.log.com.amazonaws.util.RuntimeHttpUtils;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AWSCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(Request<?> request, Date expirationDate) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request).withUri(request.getEndpoint()).build()));
        if (request.getOriginalRequest() != null) {
            this.addCustomQueryParams(request);
            this.addCustomHeaders(request);
        }
        AWSCredentialsProvider credentialsProvider = this.resolveCredentials(request);
        presigner.presignRequest(request, credentialsProvider.getCredentials(), expirationDate);
        return RuntimeHttpUtils.convertRequestToUrl(request, true, false);
    }

    private void addCustomQueryParams(Request<?> request) {
        Map<String, List<String>> queryParameters = request.getOriginalRequest().getCustomQueryParameters();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> param : queryParameters.entrySet()) {
            request.addParameters(param.getKey(), param.getValue());
        }
    }

    private void addCustomHeaders(Request<?> request) {
        Map<String, String> headers = request.getOriginalRequest().getCustomRequestHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
    }

    private AWSCredentialsProvider resolveCredentials(Request<?> request) {
        return CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.credentialsProvider);
    }

    public static class PresigningRequest
    extends AmazonWebServiceRequest {
        public PresigningRequest withRequestCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.setRequestCredentialsProvider(credentialsProvider);
            return this;
        }
    }
}

