/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.wisetime.wise_log_aws.cloud.CloudWriter;
import io.wisetime.wise_log_aws.cloud.ConfigPojo;
import io.wisetime.wise_log_aws.cloud.LayoutEngineJson;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import wise_repack.log.com.amazonaws.services.logs.model.InputLogEvent;

public class WiseAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String CLOUD_LOG_ENABLED_ENV_VAR = "CLOUD_LOG_ENABLED";
    private final ConfigPojo.ConfigPojoBuilder configBuilder = ConfigPojo.ConfigPojoBuilder.aConfigPojo();
    private final LayoutEngineJson layoutEngine = new LayoutEngineJson();
    private ScheduledExecutorService scheduledExecutor;
    private CloudWriter cloudWriter = null;
    private boolean enabled = false;
    private AtomicBoolean initialised = new AtomicBoolean(false);

    public void start() {
        this.layoutEngine.start();
        super.start();
        if (!this.enabled) {
            this.enabled = this.determineEnabled();
        }
    }

    void flushLogs() {
        if (this.cloudWriter != null) {
            try {
                this.cloudWriter.processLogEntries();
            }
            catch (Exception e) {
                this.addWarn("Internal error", e);
            }
        }
    }

    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        if (!this.initialised.get()) {
            this.runInit();
        }
        if (this.enabled && this.cloudWriter != null) {
            InputLogEvent msg = new InputLogEvent();
            msg.setTimestamp(eventObject.getTimeStamp());
            String jsonStr = this.layoutEngine.doLayout(eventObject);
            msg.setMessage(jsonStr);
            this.cloudWriter.addMessageToQueue(msg);
        }
    }

    private synchronized void runInit() {
        if (this.initialised.compareAndSet(false, true)) {
            ThreadFactory threadFactory = r -> {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("wise-log-" + UUID.randomUUID().toString().substring(0, 7));
                thread.setDaemon(true);
                return thread;
            };
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            ConfigPojo configPojo = this.configBuilder.build();
            if (this.enabled) {
                this.getOrCreateLogWriter(configPojo).ifPresent(writer -> {
                    this.cloudWriter = writer;
                    this.scheduledExecutor.scheduleWithFixedDelay(this::flushLogs, configPojo.getFlushIntervalInSeconds(), configPojo.getFlushIntervalInSeconds(), TimeUnit.SECONDS);
                    this.layoutEngine.addConfig(configPojo, this.cloudWriter.getConfigPropertyMap());
                });
            }
        }
    }

    private Optional<CloudWriter> getOrCreateLogWriter(ConfigPojo configPojo) {
        return this.cloudWriter == null ? CloudWriter.createWriter(configPojo) : Optional.of(this.cloudWriter);
    }

    private boolean determineEnabled() {
        Optional<String> cloudEnabledValue = System.getenv().keySet().stream().filter(CLOUD_LOG_ENABLED_ENV_VAR::equalsIgnoreCase).map(System.getenv()::get).findAny();
        if (!cloudEnabledValue.isPresent()) {
            System.out.println("WiseAppender is not enabled. Use CLOUD_LOG_ENABLED env variable to enable it.");
            return false;
        }
        if (!"true".equalsIgnoreCase(cloudEnabledValue.get())) {
            System.out.println("CLOUD_LOG_ENABLED env var found but false " + cloudEnabledValue.get());
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.cloudWriter != null) {
            this.scheduledExecutor.shutdown();
            try {
                this.scheduledExecutor.awaitTermination(6 * this.configBuilder.build().getFlushIntervalInSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.addWarn("Exception waiting for termination of scheduler", e);
            }
            this.flushLogs();
            this.cloudWriter.stop();
        }
        super.stop();
        this.enabled = false;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public void setDebug(boolean debug) {
        this.configBuilder.withDebug(debug);
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabled = true;
    }

    public void setFlushIntervalInSeconds(int flushIntervalInSeconds) {
        this.configBuilder.withFlushIntervalInSeconds(flushIntervalInSeconds);
    }

    public void setLogDefaultGroup(String defaultLogName) {
        this.configBuilder.withDefaultLogGroup(defaultLogName);
    }

    public void setModuleName(String moduleName) {
        this.configBuilder.withModuleName(moduleName);
    }

    public ConfigPojo getConfigPojo() {
        return this.configBuilder.build();
    }

    void enableForTest() {
        this.setEnabledByDefault(true);
        this.initialised.set(false);
    }

    void setLogsWriter(CloudWriter logsWriter) {
        this.cloudWriter = logsWriter;
    }
}

