/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import io.wisetime.wise_log_aws.cloud.ConfigPojo;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import wise_repack.log.com.amazonaws.auth.profile.internal.AllProfiles;
import wise_repack.log.com.amazonaws.auth.profile.internal.BasicProfile;
import wise_repack.log.com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import wise_repack.log.com.amazonaws.services.logs.AWSLogsAsync;
import wise_repack.log.com.amazonaws.services.logs.AWSLogsAsyncClientBuilder;
import wise_repack.log.com.amazonaws.services.logs.model.CreateLogStreamRequest;
import wise_repack.log.com.amazonaws.services.logs.model.InputLogEvent;
import wise_repack.log.com.amazonaws.services.logs.model.PutLogEventsRequest;
import wise_repack.log.com.amazonaws.services.logs.model.ResourceNotFoundException;

class CloudWriter {
    private final ConcurrentLinkedQueue<InputLogEvent> messageQueue = new ConcurrentLinkedQueue();
    private final AWSLogsAsync awsLog;
    private final String logGroupName;
    private final String logStreamName;
    private final Map<String, String> configPropertyMap = new HashMap<String, String>();

    private CloudWriter(ConfigPojo configPojo) {
        AWSLogsAsyncClientBuilder builder = AWSLogsAsyncClientBuilder.standard();
        File awsDir = new File(new File(System.getProperty("user.home")), ".aws");
        File configFile = new File(awsDir, "config");
        if (configFile.exists()) {
            AllProfiles allProfiles = BasicProfileConfigLoader.INSTANCE.loadProfiles(configFile);
            BasicProfile aDefault = allProfiles.getProfile("default");
            if (aDefault != null) {
                aDefault.getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && !((String)entry.getKey()).toLowerCase().contains("secret")).filter(entry -> !"output".equalsIgnoreCase((String)entry.getKey())).filter(entry -> !"region".equalsIgnoreCase((String)entry.getKey())).forEach(entry -> this.configPropertyMap.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue()));
            }
        } else {
            System.out.println("Config file " + configFile.getAbsolutePath() + " doesn't exist.");
        }
        this.awsLog = (AWSLogsAsync)builder.build();
        this.logGroupName = configPojo.getDefaultLogGroup().orElseGet(() -> this.configPropertyMap.get("log_group_name"));
        if (this.logGroupName == null) {
            throw new RuntimeException("Log group name is not defined, please set <logDefaultGroup> on WiseAppender config or set log_group_name=... in ${HOME}/.aws/config file");
        }
        this.logStreamName = String.format("module-%s/%s", configPojo.getModuleName().orElse("unknown"), UUID.randomUUID().toString());
        try {
            this.awsLog.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
            System.out.println("Streaming logs to group: " + this.logGroupName + ", stream: " + this.logStreamName);
        }
        catch (ResourceNotFoundException ex) {
            System.err.println("Unable to create log stream with a name " + this.logStreamName + " for a group name " + this.logGroupName + ".");
            throw ex;
        }
    }

    void processLogEntries() {
        boolean sentLimit;
        while (sentLimit = this.processToLimit()) {
        }
    }

    void stop() {
        try {
            this.awsLog.shutdown();
        }
        catch (Exception e) {
            System.out.println("Shutdown issue with cloud writer " + e.getMessage());
        }
    }

    private boolean processToLimit() {
        AtomicBoolean limitReached = new AtomicBoolean(false);
        List<InputLogEvent> eventList = this.createListFromQueue(limitReached);
        if (!eventList.isEmpty()) {
            List<InputLogEvent> eventListSorted = eventList.stream().sorted(Comparator.comparingLong(InputLogEvent::getTimestamp)).collect(Collectors.toList());
            this.awsLog.putLogEvents(new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withLogEvents(eventListSorted));
        }
        return limitReached.get();
    }

    private List<InputLogEvent> createListFromQueue(AtomicBoolean limitReached) {
        InputLogEvent logEvent;
        ArrayList<InputLogEvent> eventList = new ArrayList<InputLogEvent>();
        int maxLogEvents = 8000;
        AtomicInteger byteCount = new AtomicInteger();
        while ((logEvent = this.messageQueue.poll()) != null) {
            int MAX_AWS_PUT_SIZE;
            if (logEvent.getMessage() == null) continue;
            eventList.add(logEvent);
            if (eventList.size() >= 8000) {
                limitReached.set(true);
                return eventList;
            }
            int logBundleSize = byteCount.addAndGet(logEvent.getMessage().getBytes(StandardCharsets.UTF_8).length + 26);
            if (logBundleSize <= (MAX_AWS_PUT_SIZE = 1000576)) continue;
            limitReached.set(true);
            return eventList;
        }
        return eventList;
    }

    Map<String, String> getConfigPropertyMap() {
        return this.configPropertyMap;
    }

    void addMessageToQueue(InputLogEvent msg) {
        this.messageQueue.offer(msg);
    }

    static Optional<CloudWriter> createWriter(ConfigPojo configPojo) {
        try {
            return Optional.of(new CloudWriter(configPojo));
        }
        catch (Throwable t) {
            System.out.println("Error creating AWS cloud log writer, cause: " + t.getMessage());
            return Optional.empty();
        }
    }
}

