/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.org.joda.time.convert;

import wise_repack.log.org.joda.time.Chronology;
import wise_repack.log.org.joda.time.DateTimeUtils;
import wise_repack.log.org.joda.time.DateTimeZone;
import wise_repack.log.org.joda.time.PeriodType;
import wise_repack.log.org.joda.time.ReadablePartial;
import wise_repack.log.org.joda.time.chrono.ISOChronology;
import wise_repack.log.org.joda.time.convert.Converter;
import wise_repack.log.org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology) {
        long l = this.getInstantMillis(object, chronology);
        return chronology.get(readablePartial, l);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        return this.getPartialValues(readablePartial, object, chronology);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chronology) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

