/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.org.apache.http.client.protocol;

import java.io.IOException;
import wise_repack.log.org.apache.http.HttpEntity;
import wise_repack.log.org.apache.http.HttpEntityEnclosingRequest;
import wise_repack.log.org.apache.http.HttpException;
import wise_repack.log.org.apache.http.HttpRequest;
import wise_repack.log.org.apache.http.HttpRequestInterceptor;
import wise_repack.log.org.apache.http.HttpVersion;
import wise_repack.log.org.apache.http.ProtocolVersion;
import wise_repack.log.org.apache.http.annotation.Contract;
import wise_repack.log.org.apache.http.annotation.ThreadingBehavior;
import wise_repack.log.org.apache.http.client.config.RequestConfig;
import wise_repack.log.org.apache.http.client.protocol.HttpClientContext;
import wise_repack.log.org.apache.http.protocol.HttpContext;
import wise_repack.log.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

