/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.waiters;

import java.util.ArrayList;
import java.util.List;
import wise_repack.log.com.amazonaws.AmazonServiceException;
import wise_repack.log.com.amazonaws.annotation.SdkInternalApi;
import wise_repack.log.com.amazonaws.util.ValidationUtils;
import wise_repack.log.com.amazonaws.waiters.WaiterAcceptor;
import wise_repack.log.com.amazonaws.waiters.WaiterState;

@SdkInternalApi
class CompositeAcceptor<Output> {
    private List<WaiterAcceptor<Output>> acceptors = new ArrayList<WaiterAcceptor<Output>>();

    public CompositeAcceptor(List<WaiterAcceptor<Output>> acceptors) {
        this.acceptors = ValidationUtils.assertNotEmpty(acceptors, "acceptors");
    }

    public List<WaiterAcceptor<Output>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(Output response) {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(response)) continue;
            return acceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(AmazonServiceException exception) throws AmazonServiceException {
        for (WaiterAcceptor<Output> acceptor : this.acceptors) {
            if (!acceptor.matches(exception)) continue;
            return acceptor.getState();
        }
        throw exception;
    }
}

