/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.retry;

import wise_repack.log.com.amazonaws.AmazonClientException;
import wise_repack.log.com.amazonaws.AmazonWebServiceRequest;
import wise_repack.log.com.amazonaws.ClientConfiguration;
import wise_repack.log.com.amazonaws.annotation.SdkInternalApi;
import wise_repack.log.com.amazonaws.retry.v2.RetryPolicy;
import wise_repack.log.com.amazonaws.retry.v2.RetryPolicyContext;
import wise_repack.log.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final wise_repack.log.com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(wise_repack.log.com.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public wise_repack.log.com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

