/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.regions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import wise_repack.log.com.amazonaws.SdkClientException;
import wise_repack.log.com.amazonaws.annotation.SdkInternalApi;
import wise_repack.log.com.amazonaws.internal.config.Builder;
import wise_repack.log.com.amazonaws.regions.LegacyRegionXmlLoadUtils;
import wise_repack.log.com.amazonaws.regions.RegionMetadata;
import wise_repack.log.com.amazonaws.regions.RegionUtils;
import wise_repack.log.com.amazonaws.util.IOUtils;
import wise_repack.log.org.apache.commons.logging.Log;
import wise_repack.log.org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class LegacyRegionXmlMetadataBuilder
implements Builder<RegionMetadata> {
    private static final String REGIONS_FILE_OVERRIDE = "wise_repack.log.com.amazonaws.regions.RegionUtils.fileOverride";
    private static final String OVERRIDE_ENDPOINTS_RESOURCE_PATH = "/wise_repack/log/com/amazonaws/regions/override/regions.xml";
    private static final Log LOG = LogFactory.getLog(LegacyRegionXmlMetadataBuilder.class);

    @Override
    public RegionMetadata build() {
        return this.loadOverrideMetadataIfExists();
    }

    private RegionMetadata loadOverrideMetadataIfExists() {
        InputStream override;
        RegionMetadata metadata = this.loadFromSystemProperty();
        if (metadata == null && (override = RegionUtils.class.getResourceAsStream(OVERRIDE_ENDPOINTS_RESOURCE_PATH)) != null) {
            metadata = this.loadFromStream(override);
            IOUtils.closeQuietly(override, LOG);
        }
        return metadata;
    }

    private RegionMetadata loadFromSystemProperty() {
        String overrideFilePath = System.getProperty(REGIONS_FILE_OVERRIDE);
        if (overrideFilePath != null) {
            try {
                return LegacyRegionXmlLoadUtils.load(new File(overrideFilePath));
            }
            catch (IOException exception) {
                throw new SdkClientException("Error parsing region metadata from " + overrideFilePath, exception);
            }
        }
        return null;
    }

    private RegionMetadata loadFromStream(InputStream stream) {
        try {
            return LegacyRegionXmlLoadUtils.load(stream);
        }
        catch (IOException exception) {
            throw new SdkClientException("Error parsing region metadata from input stream", exception);
        }
    }
}

