/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import wise_repack.log.com.amazonaws.annotation.SdkInternalApi;
import wise_repack.log.com.amazonaws.partitions.PartitionRegionImpl;
import wise_repack.log.com.amazonaws.partitions.model.Partition;
import wise_repack.log.com.amazonaws.partitions.model.Region;
import wise_repack.log.com.amazonaws.regions.AbstractRegionMetadataProvider;
import wise_repack.log.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, wise_repack.log.com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, wise_repack.log.com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<wise_repack.log.com.amazonaws.regions.Region> getRegions() {
        ArrayList<wise_repack.log.com.amazonaws.regions.Region> regions = new ArrayList<wise_repack.log.com.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new wise_repack.log.com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public wise_repack.log.com.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        wise_repack.log.com.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private wise_repack.log.com.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private wise_repack.log.com.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private wise_repack.log.com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        wise_repack.log.com.amazonaws.regions.Region region = new wise_repack.log.com.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<wise_repack.log.com.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<wise_repack.log.com.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<wise_repack.log.com.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<wise_repack.log.com.amazonaws.regions.Region>();
        for (wise_repack.log.com.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

