/*
 * Decompiled with CFR 0.152.
 */
package wise_repack.log.com.amazonaws.monitoring;

import wise_repack.log.com.amazonaws.SdkClientException;
import wise_repack.log.com.amazonaws.annotation.ThreadSafe;
import wise_repack.log.com.amazonaws.monitoring.CsmConfiguration;
import wise_repack.log.com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class SystemPropertyCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() throws SdkClientException {
        String enabled = System.getProperty("wise_repack.log.com.amazonaws.sdk.csm.enabled");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!");
        }
        String port = System.getProperty("wise_repack.log.com.amazonaws.sdk.csm.port");
        String clientId = System.getProperty("wise_repack.log.com.amazonaws.sdk.csm.clientId", "");
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return new CsmConfiguration(Boolean.parseBoolean(enabled), portNumber, clientId);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!", e);
        }
    }
}

