/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import io.wisetime.wise_log_aws.cloud.ConfigPojo;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wise_repack.log.com.fasterxml.jackson.databind.JsonNode;
import wise_repack.log.com.fasterxml.jackson.databind.MapperFeature;
import wise_repack.log.com.fasterxml.jackson.databind.ObjectMapper;
import wise_repack.log.com.fasterxml.jackson.databind.SerializationFeature;
import wise_repack.log.com.fasterxml.jackson.databind.node.ObjectNode;

public class LayoutEngineJson
extends LayoutBase<ILoggingEvent> {
    private final ThrowableProxyConverter tpc;
    private final ObjectMapper om;
    private final Pattern lineBreakPattern = Pattern.compile("^(.+?)\r?\n.*");
    private static final String EMPTY = "";
    private String moduleName = null;
    private ObjectNode configMap = null;

    LayoutEngineJson() {
        this.tpc = new ThrowableProxyConverter();
        this.tpc.setOptionList(Collections.singletonList("full"));
        this.om = new ObjectMapper();
        this.om.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return EMPTY;
        }
        return this.createSingleLineJson(event);
    }

    private String createSingleLineJson(ILoggingEvent event) {
        ObjectNode rootNode = this.om.createObjectNode();
        this.getModuleName().ifPresent(modName -> rootNode.put("b_mod", (String)modName));
        this.getConfigMap().ifPresent(configNode -> rootNode.set("source", (JsonNode)configNode));
        rootNode.put("a_level", this.getSeverity(event));
        rootNode.put("b_mesg", this.getMessage(event, true));
        rootNode.set("context", this.createContextNode(event));
        try {
            Object pojo = this.om.readValue(rootNode.toString(), Object.class);
            return this.om.writeValueAsString(pojo) + CoreConstants.LINE_SEPARATOR;
        }
        catch (IOException e) {
            return rootNode.toString() + CoreConstants.LINE_SEPARATOR;
        }
    }

    private ObjectNode createContextNode(ILoggingEvent event) {
        String stackTrace;
        StackTraceElement callerData;
        ObjectNode contextNode = this.om.createObjectNode();
        contextNode.put("logger", event.getLoggerName());
        contextNode.put("thread", event.getThreadName());
        contextNode.put("message", this.getMessage(event, true));
        contextNode.put("message_full", this.getMessage(event, false));
        if (event.hasCallerData() && (callerData = event.getCallerData()[0]) != null) {
            contextNode.put("filePath", callerData.getClassName().replace('.', '/') + ".class");
            contextNode.put("lineNumber", callerData.getLineNumber());
            contextNode.put("functionName", callerData.getClassName() + "." + callerData.getMethodName());
        }
        if (this.isNotEmpty(stackTrace = this.createStackTrace(event))) {
            contextNode.put("stackAdded", true);
            contextNode.put("stackTrace", stackTrace);
        }
        if (event.getMDCPropertyMap() != null && event.getMDCPropertyMap().size() > 0) {
            contextNode.set("mdcPropertyMap", this.getMdcEvents(event));
        }
        return contextNode;
    }

    private String createStackTrace(ILoggingEvent event) {
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            try {
                String stackTrace = this.limitStackTrace(this.tpc.convert(event));
                if (this.isNotEmpty(stackTrace)) {
                    return stackTrace;
                }
            }
            catch (Exception e) {
                return "failed to log exception error - " + e.getMessage();
            }
        }
        return EMPTY;
    }

    private ObjectNode getMdcEvents(ILoggingEvent event) {
        Map propertyMap = event.getMDCPropertyMap();
        ObjectNode md5PropertyNode = this.om.createObjectNode();
        propertyMap.forEach((key, value) -> md5PropertyNode.put((String)key, (String)value));
        return md5PropertyNode;
    }

    private String limitStackTrace(String stackTrace) {
        int MAX_LENGTH_EXCEPTION;
        if (stackTrace == null) {
            return EMPTY;
        }
        int sizeOfTrace = stackTrace.length();
        if (sizeOfTrace > (MAX_LENGTH_EXCEPTION = 15000)) {
            return stackTrace.substring(0, MAX_LENGTH_EXCEPTION) + "...";
        }
        return stackTrace;
    }

    private String getMessage(ILoggingEvent event, boolean onlyIncludeFirstLine) {
        Matcher matcher;
        String formattedMessage;
        StackTraceElement callerData;
        StringBuilder messageB = new StringBuilder();
        if (event.hasCallerData() && (callerData = event.getCallerData()[0]) != null && this.isNotEmpty(callerData.getClassName())) {
            String className = callerData.getClassName().replaceAll(".+\\.", EMPTY);
            messageB.append(String.format("%s#%s:%d ", className, callerData.getMethodName(), callerData.getLineNumber()));
        }
        if (this.isNotEmpty(formattedMessage = event.getFormattedMessage())) {
            messageB.append(formattedMessage);
        } else {
            messageB.append("[null]");
        }
        String message = messageB.toString();
        if (onlyIncludeFirstLine && (matcher = this.lineBreakPattern.matcher(message)).find()) {
            return matcher.group(1);
        }
        return message;
    }

    private String getSeverity(ILoggingEvent event) {
        Level level = event.getLevel();
        if (level == Level.ALL) {
            return "DEBUG";
        }
        if (level == Level.TRACE) {
            return "DEBUG";
        }
        if (level == Level.DEBUG) {
            return "DEBUG";
        }
        if (level == Level.INFO) {
            return "INFO";
        }
        if (level == Level.WARN) {
            return "WARNING";
        }
        if (level == Level.ERROR) {
            return "ERROR";
        }
        return "DEFAULT";
    }

    private String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    private boolean isNotEmpty(String cs) {
        return cs != null && cs.length() > 0;
    }

    public void start() {
        this.tpc.start();
        super.start();
    }

    public void stop() {
        this.tpc.stop();
        super.stop();
    }

    void addConfig(ConfigPojo configPojo, Map<String, String> configPropertyMap) {
        this.moduleName = configPojo.getModuleName().orElse("unknown").trim();
        if (!configPropertyMap.isEmpty()) {
            this.configMap = this.om.createObjectNode();
            configPropertyMap.forEach((key, value) -> {
                if (key != null && value != null) {
                    this.configMap.put(key.toLowerCase().trim(), value.trim());
                }
            });
        }
    }

    private Optional<ObjectNode> getConfigMap() {
        return Optional.ofNullable(this.configMap);
    }

    private Optional<String> getModuleName() {
        return Optional.ofNullable(this.moduleName);
    }
}

