/*
 * Decompiled with CFR 0.152.
 */
package io.wisetime.wise_log_aws.cloud;

import java.util.Optional;

class ConfigPojo {
    private boolean debug = false;
    private String moduleName;
    private String defaultLogGroup;
    private int flushIntervalInSeconds = 4;

    ConfigPojo() {
    }

    public boolean isDebug() {
        return this.debug;
    }

    int getFlushIntervalInSeconds() {
        return this.flushIntervalInSeconds;
    }

    Optional<String> getModuleName() {
        return Optional.ofNullable(this.moduleName);
    }

    Optional<String> getDefaultLogGroup() {
        return Optional.ofNullable(this.defaultLogGroup);
    }

    static final class ConfigPojoBuilder {
        private boolean debug = false;
        private int flushIntervalInSeconds = 3;
        private String moduleName;
        private String defaultLogGroup;

        private ConfigPojoBuilder() {
        }

        public static ConfigPojoBuilder aConfigPojo() {
            return new ConfigPojoBuilder();
        }

        public ConfigPojoBuilder withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public ConfigPojoBuilder withFlushIntervalInSeconds(int flushIntervalInSeconds) {
            this.flushIntervalInSeconds = flushIntervalInSeconds;
            return this;
        }

        public ConfigPojoBuilder withDefaultLogGroup(String defaultLogGroup) {
            this.defaultLogGroup = defaultLogGroup;
            return this;
        }

        public ConfigPojoBuilder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ConfigPojo build() {
            ConfigPojo configPojo = new ConfigPojo();
            configPojo.debug = this.debug;
            configPojo.moduleName = this.moduleName;
            configPojo.defaultLogGroup = this.defaultLogGroup;
            configPojo.flushIntervalInSeconds = this.flushIntervalInSeconds;
            return configPojo;
        }
    }
}

