/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.Bm25Argument;
import io.weaviate.client.v1.graphql.query.argument.GroupArgument;
import io.weaviate.client.v1.graphql.query.argument.GroupByArgument;
import io.weaviate.client.v1.graphql.query.argument.HybridArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.SortArguments;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import io.weaviate.client.v1.graphql.query.fields.Field;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.fields.GenerativeSearchBuilder;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GetBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final Integer offset;
    private final Integer limit;
    private final String after;
    private final Integer autocut;
    private final String withConsistencyLevel;
    private final WhereArgument withWhereFilter;
    private final NearTextArgument withNearTextFilter;
    private final Bm25Argument withBm25Filter;
    private final HybridArgument withHybridFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final GroupArgument withGroupArgument;
    private final SortArguments withSortArguments;
    private final GenerativeSearchBuilder withGenerativeSearch;
    private final GroupByArgument withGroupByArgument;
    private final String tenant;

    private boolean includesFilterClause() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withGroupArgument, this.withAskArgument, this.withBm25Filter, this.withHybridFilter, this.limit, this.offset, this.withSortArguments, this.withGroupByArgument, this.autocut}) || !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.withConsistencyLevel, this.after, this.tenant});
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.tenant)) {
                filters.add(String.format("tenant:%s", Serializer.quote(this.tenant)));
            }
            if (this.withWhereFilter != null) {
                filters.add(this.withWhereFilter.build());
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withBm25Filter != null) {
                filters.add(this.withBm25Filter.build());
            }
            if (this.withHybridFilter != null) {
                filters.add(this.withHybridFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null) {
                filters.add(this.withNearVectorFilter.build());
            }
            if (this.withGroupArgument != null) {
                filters.add(this.withGroupArgument.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit:%s", this.limit));
            }
            if (this.offset != null) {
                filters.add(String.format("offset:%s", this.offset));
            }
            if (StringUtils.isNotBlank((CharSequence)this.after)) {
                filters.add(String.format("after:%s", Serializer.quote(this.after)));
            }
            if (this.withSortArguments != null) {
                filters.add(this.withSortArguments.build());
            }
            if (StringUtils.isNotBlank((CharSequence)this.withConsistencyLevel)) {
                filters.add(String.format("consistencyLevel:%s", Serializer.escape(this.withConsistencyLevel)));
            }
            if (this.withGroupByArgument != null) {
                filters.add(this.withGroupByArgument.build());
            }
            if (this.autocut != null) {
                filters.add(String.format("autocut:%s", this.autocut));
            }
            return String.format("(%s)", String.join((CharSequence)" ", filters));
        }
        return "";
    }

    private String createFields() {
        if (ObjectUtils.allNull((Object[])new Object[]{this.fields, this.withGenerativeSearch})) {
            return "";
        }
        if (this.withGenerativeSearch == null) {
            return this.fields.build();
        }
        Field generate = this.withGenerativeSearch.build();
        Field generateAdditional = Field.builder().name("_additional").fields(generate).build();
        if (this.fields == null) {
            return generateAdditional.build();
        }
        Map<Boolean, List<Field>> grouped = Arrays.stream(this.fields.getFields()).collect(Collectors.groupingBy(f -> "_additional".equals(f.getName())));
        List additionals = grouped.getOrDefault(true, new ArrayList());
        if (additionals.isEmpty()) {
            additionals.add(generateAdditional);
        } else {
            Field[] mergedInternalFields = (Field[])Stream.concat(Arrays.stream(((Field)additionals.get(0)).getFields()), Stream.of(generate)).toArray(Field[]::new);
            additionals.set(0, Field.builder().name("_additional").fields(mergedInternalFields).build());
        }
        Field[] allFields = (Field[])Stream.concat(((List)grouped.getOrDefault(false, new ArrayList())).stream(), additionals.stream()).toArray(Field[]::new);
        return Fields.builder().fields(allFields).build().build();
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", Serializer.escape(this.className), this.createFilterClause(), this.createFields());
    }

    GetBuilder(String className, Fields fields, Integer offset, Integer limit, String after, Integer autocut, String withConsistencyLevel, WhereArgument withWhereFilter, NearTextArgument withNearTextFilter, Bm25Argument withBm25Filter, HybridArgument withHybridFilter, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, NearVectorArgument withNearVectorFilter, GroupArgument withGroupArgument, SortArguments withSortArguments, GenerativeSearchBuilder withGenerativeSearch, GroupByArgument withGroupByArgument, String tenant) {
        this.className = className;
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.after = after;
        this.autocut = autocut;
        this.withConsistencyLevel = withConsistencyLevel;
        this.withWhereFilter = withWhereFilter;
        this.withNearTextFilter = withNearTextFilter;
        this.withBm25Filter = withBm25Filter;
        this.withHybridFilter = withHybridFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withGroupArgument = withGroupArgument;
        this.withSortArguments = withSortArguments;
        this.withGenerativeSearch = withGenerativeSearch;
        this.withGroupByArgument = withGroupByArgument;
        this.tenant = tenant;
    }

    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getAfter() {
        return this.after;
    }

    public Integer getAutocut() {
        return this.autocut;
    }

    public String getWithConsistencyLevel() {
        return this.withConsistencyLevel;
    }

    public WhereArgument getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public Bm25Argument getWithBm25Filter() {
        return this.withBm25Filter;
    }

    public HybridArgument getWithHybridFilter() {
        return this.withHybridFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public GroupArgument getWithGroupArgument() {
        return this.withGroupArgument;
    }

    public SortArguments getWithSortArguments() {
        return this.withSortArguments;
    }

    public GenerativeSearchBuilder getWithGenerativeSearch() {
        return this.withGenerativeSearch;
    }

    public GroupByArgument getWithGroupByArgument() {
        return this.withGroupByArgument;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String toString() {
        return "GetBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", after=" + this.getAfter() + ", autocut=" + this.getAutocut() + ", withConsistencyLevel=" + this.getWithConsistencyLevel() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withBm25Filter=" + this.getWithBm25Filter() + ", withHybridFilter=" + this.getWithHybridFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withGroupArgument=" + this.getWithGroupArgument() + ", withSortArguments=" + this.getWithSortArguments() + ", withGenerativeSearch=" + this.getWithGenerativeSearch() + ", withGroupByArgument=" + this.getWithGroupByArgument() + ", tenant=" + this.getTenant() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetBuilder)) {
            return false;
        }
        GetBuilder other = (GetBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$autocut = this.getAutocut();
        Integer other$autocut = other.getAutocut();
        if (this$autocut == null ? other$autocut != null : !((Object)this$autocut).equals(other$autocut)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$after = this.getAfter();
        String other$after = other.getAfter();
        if (this$after == null ? other$after != null : !this$after.equals(other$after)) {
            return false;
        }
        String this$withConsistencyLevel = this.getWithConsistencyLevel();
        String other$withConsistencyLevel = other.getWithConsistencyLevel();
        if (this$withConsistencyLevel == null ? other$withConsistencyLevel != null : !this$withConsistencyLevel.equals(other$withConsistencyLevel)) {
            return false;
        }
        WhereArgument this$withWhereFilter = this.getWithWhereFilter();
        WhereArgument other$withWhereFilter = other.getWithWhereFilter();
        if (this$withWhereFilter == null ? other$withWhereFilter != null : !((Object)this$withWhereFilter).equals(other$withWhereFilter)) {
            return false;
        }
        NearTextArgument this$withNearTextFilter = this.getWithNearTextFilter();
        NearTextArgument other$withNearTextFilter = other.getWithNearTextFilter();
        if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !((Object)this$withNearTextFilter).equals(other$withNearTextFilter)) {
            return false;
        }
        Bm25Argument this$withBm25Filter = this.getWithBm25Filter();
        Bm25Argument other$withBm25Filter = other.getWithBm25Filter();
        if (this$withBm25Filter == null ? other$withBm25Filter != null : !((Object)this$withBm25Filter).equals(other$withBm25Filter)) {
            return false;
        }
        HybridArgument this$withHybridFilter = this.getWithHybridFilter();
        HybridArgument other$withHybridFilter = other.getWithHybridFilter();
        if (this$withHybridFilter == null ? other$withHybridFilter != null : !((Object)this$withHybridFilter).equals(other$withHybridFilter)) {
            return false;
        }
        NearObjectArgument this$withNearObjectFilter = this.getWithNearObjectFilter();
        NearObjectArgument other$withNearObjectFilter = other.getWithNearObjectFilter();
        if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !((Object)this$withNearObjectFilter).equals(other$withNearObjectFilter)) {
            return false;
        }
        AskArgument this$withAskArgument = this.getWithAskArgument();
        AskArgument other$withAskArgument = other.getWithAskArgument();
        if (this$withAskArgument == null ? other$withAskArgument != null : !((Object)this$withAskArgument).equals(other$withAskArgument)) {
            return false;
        }
        NearImageArgument this$withNearImageFilter = this.getWithNearImageFilter();
        NearImageArgument other$withNearImageFilter = other.getWithNearImageFilter();
        if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !((Object)this$withNearImageFilter).equals(other$withNearImageFilter)) {
            return false;
        }
        NearVectorArgument this$withNearVectorFilter = this.getWithNearVectorFilter();
        NearVectorArgument other$withNearVectorFilter = other.getWithNearVectorFilter();
        if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !((Object)this$withNearVectorFilter).equals(other$withNearVectorFilter)) {
            return false;
        }
        GroupArgument this$withGroupArgument = this.getWithGroupArgument();
        GroupArgument other$withGroupArgument = other.getWithGroupArgument();
        if (this$withGroupArgument == null ? other$withGroupArgument != null : !((Object)this$withGroupArgument).equals(other$withGroupArgument)) {
            return false;
        }
        SortArguments this$withSortArguments = this.getWithSortArguments();
        SortArguments other$withSortArguments = other.getWithSortArguments();
        if (this$withSortArguments == null ? other$withSortArguments != null : !((Object)this$withSortArguments).equals(other$withSortArguments)) {
            return false;
        }
        GenerativeSearchBuilder this$withGenerativeSearch = this.getWithGenerativeSearch();
        GenerativeSearchBuilder other$withGenerativeSearch = other.getWithGenerativeSearch();
        if (this$withGenerativeSearch == null ? other$withGenerativeSearch != null : !((Object)this$withGenerativeSearch).equals(other$withGenerativeSearch)) {
            return false;
        }
        GroupByArgument this$withGroupByArgument = this.getWithGroupByArgument();
        GroupByArgument other$withGroupByArgument = other.getWithGroupByArgument();
        if (this$withGroupByArgument == null ? other$withGroupByArgument != null : !((Object)this$withGroupByArgument).equals(other$withGroupByArgument)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $autocut = this.getAutocut();
        result = result * 59 + ($autocut == null ? 43 : ((Object)$autocut).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : $after.hashCode());
        String $withConsistencyLevel = this.getWithConsistencyLevel();
        result = result * 59 + ($withConsistencyLevel == null ? 43 : $withConsistencyLevel.hashCode());
        WhereArgument $withWhereFilter = this.getWithWhereFilter();
        result = result * 59 + ($withWhereFilter == null ? 43 : ((Object)$withWhereFilter).hashCode());
        NearTextArgument $withNearTextFilter = this.getWithNearTextFilter();
        result = result * 59 + ($withNearTextFilter == null ? 43 : ((Object)$withNearTextFilter).hashCode());
        Bm25Argument $withBm25Filter = this.getWithBm25Filter();
        result = result * 59 + ($withBm25Filter == null ? 43 : ((Object)$withBm25Filter).hashCode());
        HybridArgument $withHybridFilter = this.getWithHybridFilter();
        result = result * 59 + ($withHybridFilter == null ? 43 : ((Object)$withHybridFilter).hashCode());
        NearObjectArgument $withNearObjectFilter = this.getWithNearObjectFilter();
        result = result * 59 + ($withNearObjectFilter == null ? 43 : ((Object)$withNearObjectFilter).hashCode());
        AskArgument $withAskArgument = this.getWithAskArgument();
        result = result * 59 + ($withAskArgument == null ? 43 : ((Object)$withAskArgument).hashCode());
        NearImageArgument $withNearImageFilter = this.getWithNearImageFilter();
        result = result * 59 + ($withNearImageFilter == null ? 43 : ((Object)$withNearImageFilter).hashCode());
        NearVectorArgument $withNearVectorFilter = this.getWithNearVectorFilter();
        result = result * 59 + ($withNearVectorFilter == null ? 43 : ((Object)$withNearVectorFilter).hashCode());
        GroupArgument $withGroupArgument = this.getWithGroupArgument();
        result = result * 59 + ($withGroupArgument == null ? 43 : ((Object)$withGroupArgument).hashCode());
        SortArguments $withSortArguments = this.getWithSortArguments();
        result = result * 59 + ($withSortArguments == null ? 43 : ((Object)$withSortArguments).hashCode());
        GenerativeSearchBuilder $withGenerativeSearch = this.getWithGenerativeSearch();
        result = result * 59 + ($withGenerativeSearch == null ? 43 : ((Object)$withGenerativeSearch).hashCode());
        GroupByArgument $withGroupByArgument = this.getWithGroupByArgument();
        result = result * 59 + ($withGroupByArgument == null ? 43 : ((Object)$withGroupByArgument).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public static class GetBuilderBuilder {
        private String className;
        private Fields fields;
        private Integer offset;
        private Integer limit;
        private String after;
        private Integer autocut;
        private String withConsistencyLevel;
        private NearTextArgument withNearTextFilter;
        private Bm25Argument withBm25Filter;
        private HybridArgument withHybridFilter;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private NearVectorArgument withNearVectorFilter;
        private GroupArgument withGroupArgument;
        private SortArguments withSortArguments;
        private GenerativeSearchBuilder withGenerativeSearch;
        private GroupByArgument withGroupByArgument;
        private String tenant;
        private WhereArgument withWhereFilter;

        @Deprecated
        public GetBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
            this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
            return this;
        }

        public GetBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
            this.withWhereFilter = whereArgument;
            return this;
        }

        GetBuilderBuilder() {
        }

        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public GetBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public GetBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetBuilderBuilder after(String after) {
            this.after = after;
            return this;
        }

        public GetBuilderBuilder autocut(Integer autocut) {
            this.autocut = autocut;
            return this;
        }

        public GetBuilderBuilder withConsistencyLevel(String withConsistencyLevel) {
            this.withConsistencyLevel = withConsistencyLevel;
            return this;
        }

        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public GetBuilderBuilder withBm25Filter(Bm25Argument withBm25Filter) {
            this.withBm25Filter = withBm25Filter;
            return this;
        }

        public GetBuilderBuilder withHybridFilter(HybridArgument withHybridFilter) {
            this.withHybridFilter = withHybridFilter;
            return this;
        }

        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public GetBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public GetBuilderBuilder withGroupArgument(GroupArgument withGroupArgument) {
            this.withGroupArgument = withGroupArgument;
            return this;
        }

        public GetBuilderBuilder withSortArguments(SortArguments withSortArguments) {
            this.withSortArguments = withSortArguments;
            return this;
        }

        public GetBuilderBuilder withGenerativeSearch(GenerativeSearchBuilder withGenerativeSearch) {
            this.withGenerativeSearch = withGenerativeSearch;
            return this;
        }

        public GetBuilderBuilder withGroupByArgument(GroupByArgument withGroupByArgument) {
            this.withGroupByArgument = withGroupByArgument;
            return this;
        }

        public GetBuilderBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.after, this.autocut, this.withConsistencyLevel, this.withWhereFilter, this.withNearTextFilter, this.withBm25Filter, this.withHybridFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument, this.withSortArguments, this.withGenerativeSearch, this.withGroupByArgument, this.tenant);
        }

        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", after=" + this.after + ", autocut=" + this.autocut + ", withConsistencyLevel=" + this.withConsistencyLevel + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withBm25Filter=" + this.withBm25Filter + ", withHybridFilter=" + this.withHybridFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ", withGenerativeSearch=" + this.withGenerativeSearch + ", withGroupByArgument=" + this.withGroupByArgument + ", tenant=" + this.tenant + ")";
        }
    }
}

