/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AggregateBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final String groupByClausePropertyName;
    private final WhereArgument withWhereFilter;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final Integer objectLimit;
    private final Integer limit;
    private final String tenant;

    private boolean includesFilterClause() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.objectLimit, this.withAskArgument, this.withNearImageFilter, this.limit}) || !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.groupByClausePropertyName, this.tenant});
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.tenant)) {
                filters.add(String.format("tenant:%s", Serializer.quote(this.tenant)));
            }
            if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
                filters.add(String.format("groupBy:%s", Serializer.quote(this.groupByClausePropertyName)));
            }
            if (this.withWhereFilter != null) {
                filters.add(this.withWhereFilter.build());
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null) {
                filters.add(this.withNearVectorFilter.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit:%s", this.limit));
            }
            if (this.objectLimit != null) {
                filters.add(String.format("objectLimit:%s", this.objectLimit));
            }
            return String.format("(%s)", String.join((CharSequence)" ", filters));
        }
        return "";
    }

    @Override
    public String buildQuery() {
        String fieldsClause = this.fields != null ? this.fields.build() : "";
        return String.format("{Aggregate{%s%s{%s}}}", Serializer.escape(this.className), this.createFilterClause(), fieldsClause);
    }

    AggregateBuilder(String className, Fields fields, String groupByClausePropertyName, WhereArgument withWhereFilter, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, NearVectorArgument withNearVectorFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, Integer objectLimit, Integer limit, String tenant) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
        this.withWhereFilter = withWhereFilter;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.objectLimit = objectLimit;
        this.limit = limit;
        this.tenant = tenant;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public WhereArgument getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public Integer getObjectLimit() {
        return this.objectLimit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String toString() {
        return "AggregateBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", groupByClausePropertyName=" + this.getGroupByClausePropertyName() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", objectLimit=" + this.getObjectLimit() + ", limit=" + this.getLimit() + ", tenant=" + this.getTenant() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateBuilder)) {
            return false;
        }
        AggregateBuilder other = (AggregateBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectLimit = this.getObjectLimit();
        Integer other$objectLimit = other.getObjectLimit();
        if (this$objectLimit == null ? other$objectLimit != null : !((Object)this$objectLimit).equals(other$objectLimit)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$groupByClausePropertyName = this.getGroupByClausePropertyName();
        String other$groupByClausePropertyName = other.getGroupByClausePropertyName();
        if (this$groupByClausePropertyName == null ? other$groupByClausePropertyName != null : !this$groupByClausePropertyName.equals(other$groupByClausePropertyName)) {
            return false;
        }
        WhereArgument this$withWhereFilter = this.getWithWhereFilter();
        WhereArgument other$withWhereFilter = other.getWithWhereFilter();
        if (this$withWhereFilter == null ? other$withWhereFilter != null : !((Object)this$withWhereFilter).equals(other$withWhereFilter)) {
            return false;
        }
        NearTextArgument this$withNearTextFilter = this.getWithNearTextFilter();
        NearTextArgument other$withNearTextFilter = other.getWithNearTextFilter();
        if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !((Object)this$withNearTextFilter).equals(other$withNearTextFilter)) {
            return false;
        }
        NearObjectArgument this$withNearObjectFilter = this.getWithNearObjectFilter();
        NearObjectArgument other$withNearObjectFilter = other.getWithNearObjectFilter();
        if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !((Object)this$withNearObjectFilter).equals(other$withNearObjectFilter)) {
            return false;
        }
        NearVectorArgument this$withNearVectorFilter = this.getWithNearVectorFilter();
        NearVectorArgument other$withNearVectorFilter = other.getWithNearVectorFilter();
        if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !((Object)this$withNearVectorFilter).equals(other$withNearVectorFilter)) {
            return false;
        }
        AskArgument this$withAskArgument = this.getWithAskArgument();
        AskArgument other$withAskArgument = other.getWithAskArgument();
        if (this$withAskArgument == null ? other$withAskArgument != null : !((Object)this$withAskArgument).equals(other$withAskArgument)) {
            return false;
        }
        NearImageArgument this$withNearImageFilter = this.getWithNearImageFilter();
        NearImageArgument other$withNearImageFilter = other.getWithNearImageFilter();
        if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !((Object)this$withNearImageFilter).equals(other$withNearImageFilter)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectLimit = this.getObjectLimit();
        result = result * 59 + ($objectLimit == null ? 43 : ((Object)$objectLimit).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $groupByClausePropertyName = this.getGroupByClausePropertyName();
        result = result * 59 + ($groupByClausePropertyName == null ? 43 : $groupByClausePropertyName.hashCode());
        WhereArgument $withWhereFilter = this.getWithWhereFilter();
        result = result * 59 + ($withWhereFilter == null ? 43 : ((Object)$withWhereFilter).hashCode());
        NearTextArgument $withNearTextFilter = this.getWithNearTextFilter();
        result = result * 59 + ($withNearTextFilter == null ? 43 : ((Object)$withNearTextFilter).hashCode());
        NearObjectArgument $withNearObjectFilter = this.getWithNearObjectFilter();
        result = result * 59 + ($withNearObjectFilter == null ? 43 : ((Object)$withNearObjectFilter).hashCode());
        NearVectorArgument $withNearVectorFilter = this.getWithNearVectorFilter();
        result = result * 59 + ($withNearVectorFilter == null ? 43 : ((Object)$withNearVectorFilter).hashCode());
        AskArgument $withAskArgument = this.getWithAskArgument();
        result = result * 59 + ($withAskArgument == null ? 43 : ((Object)$withAskArgument).hashCode());
        NearImageArgument $withNearImageFilter = this.getWithNearImageFilter();
        result = result * 59 + ($withNearImageFilter == null ? 43 : ((Object)$withNearImageFilter).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private Fields fields;
        private String groupByClausePropertyName;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private NearVectorArgument withNearVectorFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private Integer objectLimit;
        private Integer limit;
        private String tenant;
        private WhereArgument withWhereFilter;

        @Deprecated
        public AggregateBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
            this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
            return this;
        }

        public AggregateBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
            this.withWhereFilter = whereArgument;
            return this;
        }

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public AggregateBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public AggregateBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public AggregateBuilderBuilder objectLimit(Integer objectLimit) {
            this.objectLimit = objectLimit;
            return this;
        }

        public AggregateBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AggregateBuilderBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withAskArgument, this.withNearImageFilter, this.objectLimit, this.limit, this.tenant);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ", tenant=" + this.tenant + ")";
        }
    }
}

