/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class WhereArgument
implements Argument {
    private final WhereFilter filter;

    @Override
    public String build() {
        String whereStr = this.filter != null ? this.buildNestedFilter(this.filter) : "";
        return String.format("where:{%s}", whereStr);
    }

    private String buildNestedFilter(WhereFilter f) {
        LinkedHashSet<String> args = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])f.getOperands())) {
            if (f.getOperator() != null) {
                args.add(this.buildArg("operator", Serializer.escape(f.getOperator())));
            }
            args.add(String.format("operands:%s", Serializer.array(f.getOperands(), o -> String.format("{%s}", this.buildNestedFilter((WhereFilter)o)))));
        } else {
            if (ArrayUtils.isNotEmpty((Object[])f.getPath())) {
                args.add(String.format("path:%s", Serializer.arrayWithQuotes(f.getPath())));
            }
            if (f.getValueInt() != null) {
                args.add(this.buildArg("valueInt", f.getValueInt()));
            }
            if (f.getValueNumber() != null) {
                args.add(this.buildArg("valueNumber", f.getValueNumber()));
            }
            if (f.getValueBoolean() != null) {
                args.add(this.buildArg("valueBoolean", f.getValueBoolean()));
            }
            if (f.getValueString() != null) {
                args.add(this.buildArg("valueString", Serializer.quote(f.getValueString())));
            }
            if (f.getValueText() != null) {
                args.add(this.buildArg("valueText", Serializer.quote(f.getValueText())));
            }
            if (f.getValueDate() != null) {
                String date = DateFormatUtils.format((Date)f.getValueDate(), (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ");
                args.add(this.buildArg("valueDate", Serializer.quote(date)));
            }
            if (f.getValueGeoRange() != null) {
                args.add(this.buildArg("valueGeoRange", this.buildGeoRange(f.getValueGeoRange())));
            }
            if (f.getOperator() != null) {
                args.add(this.buildArg("operator", Serializer.escape(f.getOperator())));
            }
        }
        return String.join((CharSequence)" ", args);
    }

    private String buildGeoRange(WhereFilter.GeoRange geoRange) {
        WhereFilter.GeoCoordinates geoCoordinates = geoRange.getGeoCoordinates();
        WhereFilter.GeoDistance distance = geoRange.getDistance();
        if (ObjectUtils.allNotNull((Object[])new Object[]{geoCoordinates, geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance, distance.getMax()})) {
            return String.format("{geoCoordinates:{latitude:%s,longitude:%s},distance:{max:%s}}", geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance.getMax());
        }
        return "";
    }

    private String buildArg(String name, Object value) {
        return String.format("%s:%s", name, value);
    }

    WhereArgument(WhereFilter filter) {
        this.filter = filter;
    }

    public static WhereArgumentBuilder builder() {
        return new WhereArgumentBuilder();
    }

    public WhereFilter getFilter() {
        return this.filter;
    }

    public String toString() {
        return "WhereArgument(filter=" + this.getFilter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhereArgument)) {
            return false;
        }
        WhereArgument other = (WhereArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WhereFilter this$filter = this.getFilter();
        WhereFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhereArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WhereFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    public static class WhereArgumentBuilder {
        private WhereFilter filter;

        WhereArgumentBuilder() {
        }

        public WhereArgumentBuilder filter(WhereFilter filter) {
            this.filter = filter;
            return this;
        }

        public WhereArgument build() {
            return new WhereArgument(this.filter);
        }

        public String toString() {
            return "WhereArgument.WhereArgumentBuilder(filter=" + this.filter + ")";
        }
    }
}

