/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class NearImageArgument
implements Argument {
    private final String image;
    private final File imageFile;
    private final Float certainty;
    private final Float distance;

    private String readFile(File file) {
        try {
            byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
            return Base64.getEncoder().encodeToString(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getContent() {
        if (StringUtils.isNotBlank((CharSequence)this.image)) {
            if (this.image.startsWith("data:")) {
                String base64 = ";base64,";
                return this.image.substring(this.image.indexOf(base64) + base64.length());
            }
            return this.image;
        }
        if (this.imageFile != null) {
            return this.readFile(this.imageFile);
        }
        return null;
    }

    @Override
    public String build() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        String content = this.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            fields.add(String.format("image:%s", Serializer.quote(content)));
        }
        if (this.certainty != null) {
            fields.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            fields.add(String.format("distance:%s", this.distance));
        }
        return String.format("nearImage:{%s}", String.join((CharSequence)" ", fields));
    }

    NearImageArgument(String image, File imageFile, Float certainty, Float distance) {
        this.image = image;
        this.imageFile = imageFile;
        this.certainty = certainty;
        this.distance = distance;
    }

    public static NearImageArgumentBuilder builder() {
        return new NearImageArgumentBuilder();
    }

    public String getImage() {
        return this.image;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public String toString() {
        return "NearImageArgument(image=" + this.getImage() + ", imageFile=" + this.getImageFile() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearImageArgument)) {
            return false;
        }
        NearImageArgument other = (NearImageArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        File this$imageFile = this.getImageFile();
        File other$imageFile = other.getImageFile();
        return !(this$imageFile == null ? other$imageFile != null : !((Object)this$imageFile).equals(other$imageFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearImageArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        File $imageFile = this.getImageFile();
        result = result * 59 + ($imageFile == null ? 43 : ((Object)$imageFile).hashCode());
        return result;
    }

    public static class NearImageArgumentBuilder {
        private String image;
        private File imageFile;
        private Float certainty;
        private Float distance;

        NearImageArgumentBuilder() {
        }

        public NearImageArgumentBuilder image(String image) {
            this.image = image;
            return this;
        }

        public NearImageArgumentBuilder imageFile(File imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        public NearImageArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearImageArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearImageArgument build() {
            return new NearImageArgument(this.image, this.imageFile, this.certainty, this.distance);
        }

        public String toString() {
            return "NearImageArgument.NearImageArgumentBuilder(image=" + this.image + ", imageFile=" + this.imageFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ")";
        }
    }
}

