/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AskArgument
implements Argument {
    private final String question;
    private final String[] properties;
    private final Float certainty;
    private final Float distance;
    private final Boolean autocorrect;
    private final Boolean rerank;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.question)) {
            arg.add(String.format("question:%s", Serializer.quote(this.question)));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties)) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        if (this.autocorrect != null) {
            arg.add(String.format("autocorrect:%s", this.autocorrect));
        }
        if (this.rerank != null) {
            arg.add(String.format("rerank:%s", this.rerank));
        }
        return String.format("ask:{%s}", String.join((CharSequence)" ", arg));
    }

    AskArgument(String question, String[] properties, Float certainty, Float distance, Boolean autocorrect, Boolean rerank) {
        this.question = question;
        this.properties = properties;
        this.certainty = certainty;
        this.distance = distance;
        this.autocorrect = autocorrect;
        this.rerank = rerank;
    }

    public static AskArgumentBuilder builder() {
        return new AskArgumentBuilder();
    }

    public String getQuestion() {
        return this.question;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public Boolean getAutocorrect() {
        return this.autocorrect;
    }

    public Boolean getRerank() {
        return this.rerank;
    }

    public String toString() {
        return "AskArgument(question=" + this.getQuestion() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", autocorrect=" + this.getAutocorrect() + ", rerank=" + this.getRerank() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AskArgument)) {
            return false;
        }
        AskArgument other = (AskArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        Boolean this$autocorrect = this.getAutocorrect();
        Boolean other$autocorrect = other.getAutocorrect();
        if (this$autocorrect == null ? other$autocorrect != null : !((Object)this$autocorrect).equals(other$autocorrect)) {
            return false;
        }
        Boolean this$rerank = this.getRerank();
        Boolean other$rerank = other.getRerank();
        if (this$rerank == null ? other$rerank != null : !((Object)this$rerank).equals(other$rerank)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        return Arrays.deepEquals(this.getProperties(), other.getProperties());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AskArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        Boolean $autocorrect = this.getAutocorrect();
        result = result * 59 + ($autocorrect == null ? 43 : ((Object)$autocorrect).hashCode());
        Boolean $rerank = this.getRerank();
        result = result * 59 + ($rerank == null ? 43 : ((Object)$rerank).hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        return result;
    }

    public static class AskArgumentBuilder {
        private String question;
        private String[] properties;
        private Float certainty;
        private Float distance;
        private Boolean autocorrect;
        private Boolean rerank;

        AskArgumentBuilder() {
        }

        public AskArgumentBuilder question(String question) {
            this.question = question;
            return this;
        }

        public AskArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public AskArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public AskArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public AskArgumentBuilder autocorrect(Boolean autocorrect) {
            this.autocorrect = autocorrect;
            return this;
        }

        public AskArgumentBuilder rerank(Boolean rerank) {
            this.rerank = rerank;
            return this;
        }

        public AskArgument build() {
            return new AskArgument(this.question, this.properties, this.certainty, this.distance, this.autocorrect, this.rerank);
        }

        public String toString() {
            return "AskArgument.AskArgumentBuilder(question=" + this.question + ", properties=" + Arrays.deepToString(this.properties) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", autocorrect=" + this.autocorrect + ", rerank=" + this.rerank + ")";
        }
    }
}

