/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.data.util.ObjectsPath;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ObjectsChecker
extends BaseClient<String>
implements ClientResult<Boolean> {
    private final ObjectsPath objectsPath;
    private String id;
    private String className;
    private String tenant;

    public ObjectsChecker(HttpClient httpClient, Config config, ObjectsPath objectsPath) {
        super(httpClient, config);
        this.objectsPath = Objects.requireNonNull(objectsPath);
    }

    public ObjectsChecker withID(String id) {
        this.id = id;
        return this;
    }

    public ObjectsChecker withClassName(String className) {
        this.className = className;
        return this;
    }

    public ObjectsChecker withTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Override
    public Result<Boolean> run() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            WeaviateErrorMessage errorMessage = WeaviateErrorMessage.builder().message("id cannot be empty").build();
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(Stream.of(errorMessage).collect(Collectors.toList())).build();
            return new Result<Boolean>(500, false, errors);
        }
        String path = this.objectsPath.buildCheck(ObjectsPath.Params.builder().id(this.id).className(this.className).tenant(this.tenant).build());
        Response<String> resp = this.sendHeadRequest(path, String.class);
        switch (resp.getStatusCode()) {
            case 204: 
            case 404: {
                return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 204, resp.getErrors());
            }
        }
        WeaviateErrorResponse dummyError = WeaviateErrorResponse.builder().error(Collections.emptyList()).build();
        return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 204, dummyError);
    }
}

