/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.auth.nimbus;

import io.weaviate.client.Config;
import io.weaviate.client.base.Serializer;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.http.HttpResponse;
import io.weaviate.client.base.http.builder.HttpApacheClientBuilder;
import io.weaviate.client.base.http.impl.CommonsHttpClientImpl;
import io.weaviate.client.v1.auth.exception.AuthException;

public class BaseAuth {
    public static final String OIDC_URL = "/.well-known/openid-configuration";
    private final Serializer serializer = new Serializer();

    BaseAuth() {
    }

    public AuthResponse getIdAndTokenEndpoint(Config config) throws AuthException {
        CommonsHttpClientImpl client = new CommonsHttpClientImpl(config.getHeaders(), HttpApacheClientBuilder.build(config));
        String url = config.getBaseURL() + OIDC_URL;
        HttpResponse response = this.sendGetRequest(client, url);
        switch (response.getStatusCode()) {
            case 404: {
                String msg = "Auth001: The client was configured to use authentication, but weaviate is configured without authentication. Are you sure this is correct?";
                this.log(msg);
                throw new AuthException(msg);
            }
            case 200: {
                OIDCConfig oidcConfig = this.serializer.toResponse(response.getBody(), OIDCConfig.class);
                HttpResponse resp = this.sendGetRequest(client, oidcConfig.getHref());
                if (resp.getStatusCode() != 200) {
                    String errorMessage = String.format("OIDC configuration url %s returned status code %s", oidcConfig.getHref(), resp.getStatusCode());
                    throw new AuthException(errorMessage);
                }
                return new AuthResponse(oidcConfig.getClientId(), oidcConfig.getScopes(), resp.getBody());
            }
        }
        String errorMessage = String.format("OIDC configuration url %s returned status code %s", url, response.getStatusCode());
        throw new AuthException(errorMessage);
    }

    private HttpResponse sendGetRequest(HttpClient client, String url) throws AuthException {
        try {
            return client.sendGetRequest(url);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    private class OIDCConfig {
        String clientId;
        String href;
        String[] scopes;

        private OIDCConfig() {
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getHref() {
            return this.href;
        }

        public String[] getScopes() {
            return this.scopes;
        }
    }

    public class AuthResponse {
        String clientId;
        String[] scopes;
        String configuration;

        public String getClientId() {
            return this.clientId;
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public AuthResponse(String clientId, String[] scopes, String configuration) {
            this.clientId = clientId;
            this.scopes = scopes;
            this.configuration = configuration;
        }
    }
}

