// Generated by delombok at Thu Jul 06 20:35:08 UTC 2023
package io.weaviate.client.v1.graphql.query.builder;

import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import io.weaviate.client.v1.filters.WhereFilter;
import java.util.LinkedHashSet;
import java.util.Set;

public class AggregateBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final String groupByClausePropertyName;
  private final WhereArgument withWhereFilter;
  private final NearTextArgument withNearTextFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final NearVectorArgument withNearVectorFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final Integer objectLimit;
  private final Integer limit;
  private final String tenant;

  private boolean includesFilterClause() {
    return ObjectUtils.anyNotNull(withWhereFilter, withNearTextFilter, withNearObjectFilter, withNearVectorFilter, objectLimit, withAskArgument, withNearImageFilter, limit) || !StringUtils.isAllBlank(groupByClausePropertyName, tenant);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (StringUtils.isNotBlank(tenant)) {
        filters.add(String.format("tenant:%s", Serializer.quote(tenant)));
      }
      if (StringUtils.isNotBlank(groupByClausePropertyName)) {
        filters.add(String.format("groupBy:%s", Serializer.quote(groupByClausePropertyName)));
      }
      if (withWhereFilter != null) {
        filters.add(withWhereFilter.build());
      }
      if (withNearTextFilter != null) {
        filters.add(withNearTextFilter.build());
      }
      if (withNearObjectFilter != null) {
        filters.add(withNearObjectFilter.build());
      }
      if (withNearVectorFilter != null) {
        filters.add(withNearVectorFilter.build());
      }
      if (withAskArgument != null) {
        filters.add(withAskArgument.build());
      }
      if (withNearImageFilter != null) {
        filters.add(withNearImageFilter.build());
      }
      if (limit != null) {
        filters.add(String.format("limit:%s", limit));
      }
      if (objectLimit != null) {
        filters.add(String.format("objectLimit:%s", objectLimit));
      }
      return String.format("(%s)", String.join(" ", filters));
    }
    return "";
  }

  @Override
  public String buildQuery() {
    String fieldsClause = fields != null ? fields.build() : "";
    return String.format("{Aggregate{%s%s{%s}}}", Serializer.escape(className), createFilterClause(), fieldsClause);
  }

  // created to support both types of setters: WhereArgument and deprecated WhereFilter
  public static class AggregateBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private String groupByClausePropertyName;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private Integer objectLimit;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private String tenant;
    private WhereArgument withWhereFilter;

    @Deprecated
    public AggregateBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
      this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
      return this;
    }

    public AggregateBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
      this.withWhereFilter = whereArgument;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    AggregateBuilderBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder groupByClausePropertyName(final String groupByClausePropertyName) {
      this.groupByClausePropertyName = groupByClausePropertyName;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder objectLimit(final Integer objectLimit) {
      this.objectLimit = objectLimit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public AggregateBuilder.AggregateBuilderBuilder tenant(final String tenant) {
      this.tenant = tenant;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public AggregateBuilder build() {
      return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withAskArgument, this.withNearImageFilter, this.objectLimit, this.limit, this.tenant);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ", tenant=" + this.tenant + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  AggregateBuilder(final String className, final Fields fields, final String groupByClausePropertyName, final WhereArgument withWhereFilter, final NearTextArgument withNearTextFilter, final NearObjectArgument withNearObjectFilter, final NearVectorArgument withNearVectorFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final Integer objectLimit, final Integer limit, final String tenant) {
    this.className = className;
    this.fields = fields;
    this.groupByClausePropertyName = groupByClausePropertyName;
    this.withWhereFilter = withWhereFilter;
    this.withNearTextFilter = withNearTextFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.objectLimit = objectLimit;
    this.limit = limit;
    this.tenant = tenant;
  }

  @java.lang.SuppressWarnings("all")
  public static AggregateBuilder.AggregateBuilderBuilder builder() {
    return new AggregateBuilder.AggregateBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public String getGroupByClausePropertyName() {
    return this.groupByClausePropertyName;
  }

  @java.lang.SuppressWarnings("all")
  public WhereArgument getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getObjectLimit() {
    return this.objectLimit;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public String getTenant() {
    return this.tenant;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "AggregateBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", groupByClausePropertyName=" + this.getGroupByClausePropertyName() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", objectLimit=" + this.getObjectLimit() + ", limit=" + this.getLimit() + ", tenant=" + this.getTenant() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AggregateBuilder)) return false;
    final AggregateBuilder other = (AggregateBuilder) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$objectLimit = this.getObjectLimit();
    final java.lang.Object other$objectLimit = other.getObjectLimit();
    if (this$objectLimit == null ? other$objectLimit != null : !this$objectLimit.equals(other$objectLimit)) return false;
    final java.lang.Object this$limit = this.getLimit();
    final java.lang.Object other$limit = other.getLimit();
    if (this$limit == null ? other$limit != null : !this$limit.equals(other$limit)) return false;
    final java.lang.Object this$className = this.getClassName();
    final java.lang.Object other$className = other.getClassName();
    if (this$className == null ? other$className != null : !this$className.equals(other$className)) return false;
    final java.lang.Object this$fields = this.getFields();
    final java.lang.Object other$fields = other.getFields();
    if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
    final java.lang.Object this$groupByClausePropertyName = this.getGroupByClausePropertyName();
    final java.lang.Object other$groupByClausePropertyName = other.getGroupByClausePropertyName();
    if (this$groupByClausePropertyName == null ? other$groupByClausePropertyName != null : !this$groupByClausePropertyName.equals(other$groupByClausePropertyName)) return false;
    final java.lang.Object this$withWhereFilter = this.getWithWhereFilter();
    final java.lang.Object other$withWhereFilter = other.getWithWhereFilter();
    if (this$withWhereFilter == null ? other$withWhereFilter != null : !this$withWhereFilter.equals(other$withWhereFilter)) return false;
    final java.lang.Object this$withNearTextFilter = this.getWithNearTextFilter();
    final java.lang.Object other$withNearTextFilter = other.getWithNearTextFilter();
    if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !this$withNearTextFilter.equals(other$withNearTextFilter)) return false;
    final java.lang.Object this$withNearObjectFilter = this.getWithNearObjectFilter();
    final java.lang.Object other$withNearObjectFilter = other.getWithNearObjectFilter();
    if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !this$withNearObjectFilter.equals(other$withNearObjectFilter)) return false;
    final java.lang.Object this$withNearVectorFilter = this.getWithNearVectorFilter();
    final java.lang.Object other$withNearVectorFilter = other.getWithNearVectorFilter();
    if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !this$withNearVectorFilter.equals(other$withNearVectorFilter)) return false;
    final java.lang.Object this$withAskArgument = this.getWithAskArgument();
    final java.lang.Object other$withAskArgument = other.getWithAskArgument();
    if (this$withAskArgument == null ? other$withAskArgument != null : !this$withAskArgument.equals(other$withAskArgument)) return false;
    final java.lang.Object this$withNearImageFilter = this.getWithNearImageFilter();
    final java.lang.Object other$withNearImageFilter = other.getWithNearImageFilter();
    if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !this$withNearImageFilter.equals(other$withNearImageFilter)) return false;
    final java.lang.Object this$tenant = this.getTenant();
    final java.lang.Object other$tenant = other.getTenant();
    if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AggregateBuilder;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $objectLimit = this.getObjectLimit();
    result = result * PRIME + ($objectLimit == null ? 43 : $objectLimit.hashCode());
    final java.lang.Object $limit = this.getLimit();
    result = result * PRIME + ($limit == null ? 43 : $limit.hashCode());
    final java.lang.Object $className = this.getClassName();
    result = result * PRIME + ($className == null ? 43 : $className.hashCode());
    final java.lang.Object $fields = this.getFields();
    result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
    final java.lang.Object $groupByClausePropertyName = this.getGroupByClausePropertyName();
    result = result * PRIME + ($groupByClausePropertyName == null ? 43 : $groupByClausePropertyName.hashCode());
    final java.lang.Object $withWhereFilter = this.getWithWhereFilter();
    result = result * PRIME + ($withWhereFilter == null ? 43 : $withWhereFilter.hashCode());
    final java.lang.Object $withNearTextFilter = this.getWithNearTextFilter();
    result = result * PRIME + ($withNearTextFilter == null ? 43 : $withNearTextFilter.hashCode());
    final java.lang.Object $withNearObjectFilter = this.getWithNearObjectFilter();
    result = result * PRIME + ($withNearObjectFilter == null ? 43 : $withNearObjectFilter.hashCode());
    final java.lang.Object $withNearVectorFilter = this.getWithNearVectorFilter();
    result = result * PRIME + ($withNearVectorFilter == null ? 43 : $withNearVectorFilter.hashCode());
    final java.lang.Object $withAskArgument = this.getWithAskArgument();
    result = result * PRIME + ($withAskArgument == null ? 43 : $withAskArgument.hashCode());
    final java.lang.Object $withNearImageFilter = this.getWithNearImageFilter();
    result = result * PRIME + ($withNearImageFilter == null ? 43 : $withNearImageFilter.hashCode());
    final java.lang.Object $tenant = this.getTenant();
    result = result * PRIME + ($tenant == null ? 43 : $tenant.hashCode());
    return result;
  }
}
