// Generated by delombok at Thu Jul 06 20:35:08 UTC 2023
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class WhereArgument implements Argument {
  private final WhereFilter filter;

  @Override
  public String build() {
    String whereStr = filter != null ? buildNestedFilter(filter) : "";
    return String.format("where:{%s}", whereStr);
  }

  private String buildNestedFilter(WhereFilter f) {
    Set<String> args = new LinkedHashSet<>();
    if (ArrayUtils.isNotEmpty(f.getOperands())) {
      if (f.getOperator() != null) {
        args.add(buildArg("operator", Serializer.escape(f.getOperator())));
      }
      args.add(String.format("operands:%s", Serializer.array(f.getOperands(), o -> String.format("{%s}", buildNestedFilter(o)))));
    } else {
      if (ArrayUtils.isNotEmpty(f.getPath())) {
        args.add(String.format("path:%s", Serializer.arrayWithQuotes(f.getPath())));
      }
      if (f.getValueInt() != null) {
        args.add(buildArg("valueInt", f.getValueInt()));
      }
      if (f.getValueNumber() != null) {
        args.add(buildArg("valueNumber", f.getValueNumber()));
      }
      if (f.getValueBoolean() != null) {
        args.add(buildArg("valueBoolean", f.getValueBoolean()));
      }
      if (f.getValueString() != null) {
        args.add(buildArg("valueString", Serializer.quote(f.getValueString())));
      }
      if (f.getValueText() != null) {
        args.add(buildArg("valueText", Serializer.quote(f.getValueText())));
      }
      if (f.getValueDate() != null) {
        String date = DateFormatUtils.format(f.getValueDate(), "yyyy-MM-dd\'T\'HH:mm:ssZZZZZ");
        args.add(buildArg("valueDate", Serializer.quote(date)));
      }
      if (f.getValueGeoRange() != null) {
        args.add(buildArg("valueGeoRange", buildGeoRange(f.getValueGeoRange())));
      }
      if (f.getOperator() != null) {
        args.add(buildArg("operator", Serializer.escape(f.getOperator())));
      }
    }
    return String.join(" ", args);
  }

  private String buildGeoRange(WhereFilter.GeoRange geoRange) {
    WhereFilter.GeoCoordinates geoCoordinates = geoRange.getGeoCoordinates();
    WhereFilter.GeoDistance distance = geoRange.getDistance();
    if (ObjectUtils.allNotNull(geoCoordinates, geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance, distance.getMax())) {
      return String.format("{geoCoordinates:{latitude:%s,longitude:%s},distance:{max:%s}}", geoCoordinates.getLatitude(), geoCoordinates.getLongitude(), distance.getMax());
    }
    return "";
  }

  private String buildArg(String name, Object value) {
    return String.format("%s:%s", name, value);
  }

  @java.lang.SuppressWarnings("all")
  WhereArgument(final WhereFilter filter) {
    this.filter = filter;
  }


  @java.lang.SuppressWarnings("all")
  public static class WhereArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private WhereFilter filter;

    @java.lang.SuppressWarnings("all")
    WhereArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public WhereArgument.WhereArgumentBuilder filter(final WhereFilter filter) {
      this.filter = filter;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public WhereArgument build() {
      return new WhereArgument(this.filter);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "WhereArgument.WhereArgumentBuilder(filter=" + this.filter + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static WhereArgument.WhereArgumentBuilder builder() {
    return new WhereArgument.WhereArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public WhereFilter getFilter() {
    return this.filter;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "WhereArgument(filter=" + this.getFilter() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WhereArgument)) return false;
    final WhereArgument other = (WhereArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$filter = this.getFilter();
    final java.lang.Object other$filter = other.getFilter();
    if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WhereArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $filter = this.getFilter();
    result = result * PRIME + ($filter == null ? 43 : $filter.hashCode());
    return result;
  }
}
