/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warp.sdk;

import io.warp10.WarpConfig;
import io.warp10.continuum.Tokens;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Capabilities {
    protected Map<String, String> capabilities = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_CAPABILITIES = new LinkedHashMap<String, String>();

    public static Capabilities get(WarpScriptStack stack) {
        if (stack.getAttribute("stack.capabilities") instanceof AtomicReference && ((AtomicReference)stack.getAttribute("stack.capabilities")).get() instanceof Capabilities) {
            return (Capabilities)((AtomicReference)stack.getAttribute("stack.capabilities")).get();
        }
        return null;
    }

    public static void set(WarpScriptStack stack, Capabilities capabilities) {
        stack.setAttribute("stack.capabilities", new AtomicReference<Capabilities>(capabilities));
    }

    public static String get(WarpScriptStack stack, String name) {
        Capabilities capabilities = Capabilities.get(stack);
        String cap = null;
        if (null != capabilities) {
            cap = capabilities.capabilities.get(name);
        }
        if (null == cap) {
            cap = DEFAULT_CAPABILITIES.get(name);
        }
        return cap;
    }

    public static Long getLong(WarpScriptStack stack, String name) throws WarpScriptException {
        return Capabilities.getLong(stack, name, null);
    }

    public static Long getLong(WarpScriptStack stack, String name, Long defaultValue) throws WarpScriptException {
        String cap = Capabilities.get(stack, name);
        if (null != cap) {
            try {
                return Long.parseLong(cap);
            }
            catch (Throwable t) {
                throw new WarpScriptException("Error parsing capability.");
            }
        }
        return defaultValue;
    }

    public static Map<String, String> get(WarpScriptStack stack, List<Object> names) {
        Capabilities capabilities = Capabilities.get(stack);
        LinkedHashMap<String, String> caps = new LinkedHashMap<String, String>();
        if (null != capabilities) {
            if (null == names || names.isEmpty()) {
                caps.putAll(capabilities.capabilities);
            } else {
                for (Object elt : names) {
                    if (!(elt instanceof String)) continue;
                    caps.put((String)elt, capabilities.capabilities.get((String)elt));
                }
            }
        }
        if (null != names && !names.isEmpty()) {
            for (Object elt : names) {
                String def = DEFAULT_CAPABILITIES.get(elt);
                if (null == def) continue;
                caps.putIfAbsent((String)elt, def);
            }
        } else {
            for (String cap : DEFAULT_CAPABILITIES.keySet()) {
                caps.putIfAbsent(cap, DEFAULT_CAPABILITIES.get(cap));
            }
        }
        return caps;
    }

    public static void add(WarpScriptStack stack, String token) throws WarpScriptException {
        Map<String, String> attributes = null;
        try {
            ReadToken rtoken = Tokens.extractReadToken(token);
            attributes = rtoken.getAttributes();
        }
        catch (Exception e) {
            try {
                WriteToken wtoken = Tokens.extractWriteToken(token);
                attributes = wtoken.getAttributes();
            }
            catch (Exception ee) {
                throw new WarpScriptException("invalid token.");
            }
        }
        if (null != attributes && !attributes.isEmpty()) {
            Capabilities capabilities = Capabilities.get(stack);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (!entry.getKey().startsWith(".cap:")) continue;
                if (null == capabilities) {
                    capabilities = new Capabilities();
                    Capabilities.set(stack, capabilities);
                }
                capabilities.putIfAbsent(entry.getKey().substring(".cap:".length()), entry.getValue());
            }
        }
    }

    public void clear() {
        this.capabilities.clear();
    }

    public Object remove(String key) {
        return this.capabilities.remove(key);
    }

    public Object putIfAbsent(String key, String value) {
        return this.capabilities.putIfAbsent(key, value);
    }

    public String get(String key) {
        return this.capabilities.get(key);
    }

    public Capabilities clone() {
        Capabilities newcaps = new Capabilities();
        newcaps.capabilities.putAll(this.capabilities);
        return newcaps;
    }

    static {
        if (null != WarpConfig.getProperty("warp.capabilities.default")) {
            MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
            stack.maxLimits();
            try {
                stack.execMulti(WarpConfig.getProperty("warp.capabilities.default"));
                if (1 != stack.depth() || !(stack.peek() instanceof Map)) {
                    throw new WarpScriptException("Invalid value for 'warp.capabilities.default', expected a WarpScript map.");
                }
                Map capabilities = (Map)stack.pop();
                for (Map.Entry capability : capabilities.entrySet()) {
                    if (!(capability.getKey() instanceof String) || !(capability.getValue() instanceof String)) {
                        throw new WarpScriptException("Invalid value for 'warp.capabilities.default', expected a WarpScript map with STRING keys and values.");
                    }
                    DEFAULT_CAPABILITIES.put(capability.getKey().toString(), capability.getValue().toString());
                }
            }
            catch (WarpScriptException wse) {
                throw new RuntimeException("Error initializing default capabilities.");
            }
        }
    }
}

