/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.unary;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;

public class TOTIMESTAMP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOTIMESTAMP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String) && !(top instanceof Date)) {
            throw new WarpScriptException(this.getName() + " expects an ISO8601 timestamp or a Date instance on top of the stack.");
        }
        if (top instanceof Date) {
            long ts = ((Date)top).getTime() * Constants.TIME_UNITS_PER_MS;
            stack.push(ts);
        } else {
            long ts = TOTIMESTAMP.parseTimestamp(top.toString());
            stack.push(ts);
        }
        return stack;
    }

    public static long parseTimestamp(String timestamp) throws WarpScriptException {
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(timestamp);
            long ts = zdt.getLong(ChronoField.INSTANT_SECONDS) * Constants.TIME_UNITS_PER_S + zdt.getLong(ChronoField.NANO_OF_SECOND) / (1000000L / Constants.TIME_UNITS_PER_MS);
            return ts;
        }
        catch (DateTimeParseException dtpe) {
            throw new WarpScriptException("Can only parse an ISO8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss) with a specified time zone.", dtpe);
        }
    }
}

