/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.unary;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;

public class TOBITS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean asFloat;

    public TOBITS(String name, boolean asFloat) {
        super(name);
        this.asFloat = asFloat;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op = stack.pop();
        if (!(op instanceof Number) && !(op instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " operates on a DOUBLE, LONG or Geo Time Series thereof.");
        }
        if (op instanceof Number) {
            if (this.asFloat) {
                int bits = Float.floatToRawIntBits(((Number)op).floatValue());
                stack.push((long)bits & 0xFFFFFFFFL);
            } else {
                stack.push(Double.doubleToRawLongBits(((Number)op).doubleValue()));
            }
        } else {
            GeoTimeSerie gts = (GeoTimeSerie)op;
            if (GeoTimeSerie.TYPE.LONG != gts.getType() && GeoTimeSerie.TYPE.DOUBLE != gts.getType()) {
                throw new WarpScriptException(this.getName() + " operates on a DOUBLE or LONG Geo Time Series.");
            }
            GTSEncoder encoder = new GTSEncoder(0L);
            encoder.setMetadata(new Metadata(gts.getMetadata()));
            int n = gts.size();
            try {
                for (int i = 0; i < n; ++i) {
                    Long value;
                    if (this.asFloat) {
                        int bits = Float.floatToRawIntBits(((Number)GTSHelper.valueAtIndex(gts, i)).floatValue());
                        value = (long)bits & 0xFFFFFFFFL;
                    } else {
                        value = Double.doubleToRawLongBits(((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue());
                    }
                    encoder.addValue(GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value);
                }
            }
            catch (IOException ioe) {
                throw new WarpScriptException(ioe);
            }
            stack.push(encoder.getDecoder(true).decode());
        }
        return stack;
    }
}

