/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.rendering;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.processing.ProcessingUtil;
import java.util.List;
import processing.core.PGraphics;

public class PblendMode
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PblendMode(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        List<Object> params = ProcessingUtil.parseParams(stack, 1);
        PGraphics pg = (PGraphics)params.get(0);
        String mode = params.get(1).toString();
        if ("BLEND".equals(mode)) {
            pg.parent.blendMode(1);
        } else if ("ADD".equals(mode)) {
            pg.parent.blendMode(2);
        } else if ("SUBTRACT".equals(mode)) {
            pg.parent.blendMode(4);
        } else if ("DARKEST".equals(mode)) {
            pg.parent.blendMode(16);
        } else if ("LIGHTEST".equals(mode)) {
            pg.parent.blendMode(8);
        } else if ("DIFFERENCE".equals(mode)) {
            pg.parent.blendMode(32);
        } else if ("EXCLUSION".equals(mode)) {
            pg.parent.blendMode(64);
        } else if ("MULTIPLY".equals(mode)) {
            pg.parent.blendMode(128);
        } else if ("SCREEN".equals(mode)) {
            pg.parent.blendMode(256);
        } else if ("REPLACE".equals(mode)) {
            pg.parent.blendMode(0);
        } else {
            throw new WarpScriptException(this.getName() + ": invalid mode, should be 'BLEND', 'ADD', 'SUBTRACT', 'DARKEST', 'LIGHTEST', 'DIFFERENCE', 'EXCLUSION', 'MULTIPLY', 'SCREEN', or 'REPLACE'.");
        }
        stack.push(pg);
        return stack;
    }
}

