/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MapperRegExpMatch
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final Pattern pattern;

    public MapperRegExpMatch(String name, Pattern pattern) {
        super(name);
        this.pattern = pattern;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        Matcher matcher = null;
        for (int i = 0; i < values.length; ++i) {
            if (null == matcher) {
                matcher = this.pattern.matcher((String)values[i]);
            } else {
                matcher.reset((String)values[i]);
            }
            if (!(values[i] instanceof String) || !matcher.matches()) continue;
            return new Object[]{tick, locations[i], elevations[i], values[i]};
        }
        return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, null};
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Pattern pattern;
            Object value = stack.pop();
            if (!(value instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a regular expression STRING.");
            }
            try {
                pattern = Pattern.compile((String)value);
            }
            catch (PatternSyntaxException pse) {
                throw new WarpScriptException(this.getName() + " expects a valid regular expression.", pse);
            }
            stack.push(new MapperRegExpMatch(this.getName(), pattern));
            return stack;
        }
    }
}

