/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class MapperParseDouble
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final NumberFormat format;

    public MapperParseDouble(String name) {
        super(name);
        this.format = null;
    }

    public MapperParseDouble(String name, Object language) throws WarpScriptException {
        super(name);
        if (!(language instanceof String)) {
            throw new WarpScriptException("Invalid parameter type for " + this.getName() + ", expects a language tag (a string) on top of the stack.");
        }
        Locale locale = Locale.forLanguageTag((String)language);
        this.format = NumberFormat.getInstance(locale);
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        Double value = null;
        long location = locations[0];
        long elevation = elevations[0];
        if (null != values[0] && values[0] instanceof String) {
            try {
                value = this.format.parse((String)values[0]).doubleValue();
            }
            catch (NumberFormatException | ParseException e) {
                value = null;
            }
        }
        return new Object[]{tick, location, elevation, value};
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object language = stack.pop();
            if (!(language instanceof String)) {
                throw new WarpScriptException("Invalid parameter type for " + this.getName() + ", expects a language tag (a string) on top of the stack.");
            }
            stack.push(new MapperParseDouble(this.getName(), language));
            return stack;
        }
    }
}

