/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLoopBreakException;
import io.warp10.script.WarpScriptLoopContinueException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class WHILE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final long maxtime;

    public WHILE(String name) {
        super(name);
        this.maxtime = -1L;
    }

    public WHILE(String name, long maxtime) {
        super(name);
        this.maxtime = maxtime;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        boolean pushCounter = false;
        if (top instanceof Boolean) {
            pushCounter = (Boolean)top;
            top = stack.pop();
        }
        Object runMacro = top;
        Object whileMacro = stack.pop();
        if (!(runMacro instanceof WarpScriptStack.Macro) || !(whileMacro instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects two macros on top of the stack.");
        }
        long now = System.currentTimeMillis();
        long maxtime = this.maxtime > 0L ? this.maxtime : (Long)stack.getAttribute("loop.maxduration");
        long counter = 0L;
        while (true) {
            if (maxtime > 0L && System.currentTimeMillis() - now > maxtime) {
                throw new WarpScriptException(this.getName() + " executed for too long (> " + maxtime + " ms). Consider raising the limit or using capabilities.");
            }
            stack.exec((WarpScriptStack.Macro)whileMacro);
            top = stack.pop();
            if (!(top instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects its 'WHILE' macro to leave a boolean on top of the stack.");
            }
            if (Boolean.FALSE.equals(top)) break;
            try {
                if (pushCounter) {
                    stack.push(counter++);
                }
                stack.exec((WarpScriptStack.Macro)runMacro);
                continue;
            }
            catch (WarpScriptLoopBreakException elbe) {
            }
            catch (WarpScriptLoopContinueException warpScriptLoopContinueException) {
                continue;
            }
            break;
        }
        return stack;
    }
}

