/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.ENDLIST;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.MARK;
import io.warp10.script.functions.NULL;
import io.warp10.script.functions.POPR;
import io.warp10.script.functions.PUSHR;
import io.warp10.script.functions.RUN;
import io.warp10.script.functions.RUNR;
import io.warp10.script.functions.STORE;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class VARS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public VARS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        boolean onlyStoreAndPopr = false;
        if (top instanceof Boolean) {
            onlyStoreAndPopr = (Boolean)top;
            top = stack.pop();
        }
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        try {
            stack.push(VARS.getVars(macro, onlyStoreAndPopr));
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " failed.", wse);
        }
        return stack;
    }

    public static List<Object> getVars(WarpScriptStack.Macro macro) throws WarpScriptException {
        return VARS.getVars(macro, false);
    }

    public static List<Object> getVars(WarpScriptStack.Macro macro, boolean onlyStoreAndPopr) throws WarpScriptException {
        LinkedHashSet<Long> symbols = new LinkedHashSet<Long>();
        final HashMap<Long, AtomicInteger> occurrences = new HashMap<Long, AtomicInteger>();
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add(macro);
        boolean abort = false;
        block0: while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            block1: for (int i = 0; i < statements.size(); ++i) {
                AtomicInteger occ;
                Object previousSymbol;
                AtomicInteger occ2;
                Object currentSymbol = statements.get(i);
                if (currentSymbol instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)currentSymbol);
                    continue;
                }
                if (currentSymbol instanceof POPR) {
                    symbols.add(Long.valueOf(((POPR)currentSymbol).getRegister()));
                    occ2 = (AtomicInteger)occurrences.get(((POPR)currentSymbol).getRegister());
                    if (null == occ2) {
                        occ2 = new AtomicInteger();
                        occurrences.put(Long.valueOf(((POPR)currentSymbol).getRegister()), occ2);
                    }
                    occ2.incrementAndGet();
                    continue;
                }
                if (currentSymbol instanceof PUSHR) {
                    if (!onlyStoreAndPopr) {
                        symbols.add(Long.valueOf(((PUSHR)currentSymbol).getRegister()));
                    }
                    if (null == (occ2 = (AtomicInteger)occurrences.get(((PUSHR)currentSymbol).getRegister()))) {
                        occ2 = new AtomicInteger();
                        occurrences.put(Long.valueOf(((PUSHR)currentSymbol).getRegister()), occ2);
                    }
                    occ2.incrementAndGet();
                    continue;
                }
                if (currentSymbol instanceof RUNR) {
                    if (!onlyStoreAndPopr) {
                        symbols.add(Long.valueOf(((RUNR)currentSymbol).getRegister()));
                    }
                    if (null == (occ2 = (AtomicInteger)occurrences.get(((RUNR)currentSymbol).getRegister()))) {
                        occ2 = new AtomicInteger();
                        occurrences.put(Long.valueOf(((RUNR)currentSymbol).getRegister()), occ2);
                    }
                    occ2.incrementAndGet();
                    continue;
                }
                if (currentSymbol instanceof LOAD || currentSymbol instanceof CSTORE || currentSymbol instanceof RUN) {
                    if (0 == i) {
                        abort = true;
                        continue block0;
                    }
                    previousSymbol = statements.get(i - 1);
                    if (previousSymbol instanceof String || previousSymbol instanceof Long) {
                        AtomicInteger occ3;
                        if (currentSymbol instanceof CSTORE || currentSymbol instanceof LOAD && !onlyStoreAndPopr) {
                            symbols.add((Long)previousSymbol);
                        }
                        if (null == (occ3 = (AtomicInteger)occurrences.get(previousSymbol))) {
                            occ3 = new AtomicInteger();
                            occurrences.put((Long)previousSymbol, occ3);
                        }
                        occ3.incrementAndGet();
                        continue;
                    }
                    abort = true;
                    continue block0;
                }
                if (!(currentSymbol instanceof STORE)) continue;
                if (0 == i) {
                    abort = true;
                    continue block0;
                }
                previousSymbol = statements.get(i - 1);
                if (previousSymbol instanceof List) {
                    for (Object elt : (List)previousSymbol) {
                        if (elt instanceof String || elt instanceof Long) {
                            symbols.add((Long)elt);
                            occ = (AtomicInteger)occurrences.get(elt);
                            if (null == occ) {
                                occ = new AtomicInteger();
                                occurrences.put((Long)elt, occ);
                            }
                            occ.incrementAndGet();
                            continue;
                        }
                        if (null == elt) continue;
                        abort = true;
                        continue block1;
                    }
                    continue;
                }
                if (previousSymbol instanceof ENDLIST) {
                    int idx = i - 2;
                    while (idx >= 0 && !(statements.get(idx) instanceof MARK)) {
                        Object stmt;
                        if ((stmt = statements.get(idx--)) instanceof String || stmt instanceof Long) {
                            symbols.add((Long)stmt);
                            occ = (AtomicInteger)occurrences.get(stmt);
                            if (null == occ) {
                                occ = new AtomicInteger();
                                occurrences.put((Long)stmt, occ);
                            }
                            occ.incrementAndGet();
                            continue;
                        }
                        if (null == stmt || stmt instanceof NULL) continue;
                        abort = true;
                        continue block1;
                    }
                    continue;
                }
                if (previousSymbol instanceof String || previousSymbol instanceof Long) {
                    symbols.add((Long)previousSymbol);
                    AtomicInteger occ4 = (AtomicInteger)occurrences.get(previousSymbol);
                    if (null == occ4) {
                        occ4 = new AtomicInteger();
                        occurrences.put((Long)previousSymbol, occ4);
                    }
                    occ4.incrementAndGet();
                    continue;
                }
                abort = true;
                continue block0;
            }
        }
        if (abort) {
            throw new WarpScriptException("Encountered a LOAD/STORE or CSTORE operation with a non explicit symbol name.");
        }
        ArrayList<Object> vars = new ArrayList<Object>(symbols);
        vars.sort(new Comparator<Object>(){

            @Override
            public int compare(Object s1, Object s2) {
                AtomicInteger occ1 = (AtomicInteger)occurrences.get(s1);
                AtomicInteger occ2 = (AtomicInteger)occurrences.get(s2);
                if (occ1.get() < occ2.get()) {
                    return 1;
                }
                if (occ1.get() > occ2.get()) {
                    return -1;
                }
                return s1.toString().compareTo(s2.toString());
            }
        });
        return vars;
    }
}

