/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.PACK;
import java.util.ArrayList;
import java.util.BitSet;

public class UNPACK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public UNPACK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a format string on top of the stack.");
        }
        String fmt = o.toString();
        o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on an array of bytes.");
        }
        byte[] data = (byte[])o;
        BitSet bigendians = new BitSet();
        ArrayList<Character> types = new ArrayList<Character>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        PACK.parseFormat(this, fmt, bigendians, types, lengths);
        int bitno = 0;
        byte[] atad = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            atad[i] = (byte)((((long)data[i] & 0xFFL) * 0x202020202L & 0x10884422010L) % 1023L & 0xFFL);
        }
        BitSet bits = BitSet.valueOf(atad);
        ArrayList<Comparable<Boolean>> values = new ArrayList<Comparable<Boolean>>();
        block6: for (int i = 0; i < types.size(); ++i) {
            char type = ((Character)types.get(i)).charValue();
            int len = (Integer)lengths.get(i);
            if ('s' == type || 'S' == type) {
                bitno += len;
                continue;
            }
            if ('B' == type) {
                values.add(Boolean.valueOf(bits.get(bitno++)));
                continue;
            }
            boolean bigendian = bigendians.get(i);
            long value = 0L;
            for (int k = 0; k < len; ++k) {
                value <<= 1;
                if (!bigendian) {
                    value |= (long)(bits.get(bitno + len - 1 - k) ? 1 : 0);
                    continue;
                }
                value |= (long)(bits.get(bitno + k) ? 1 : 0);
            }
            bitno += len;
            switch (type) {
                case 'D': {
                    values.add(Double.valueOf(Double.longBitsToDouble(value)));
                    continue block6;
                }
                case 'L': {
                    values.add(Long.valueOf(value << 64 - len >> 64 - len));
                    continue block6;
                }
                case 'U': {
                    values.add(Long.valueOf(value));
                }
            }
        }
        stack.push(values);
        return stack;
    }
}

