/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.functions.ADDDURATION;
import io.warp10.script.functions.BUCKETIZECALENDAR;
import java.util.Map;
import org.joda.time.DateTimeZone;

public class UNBUCKETIZECALENDAR
extends GTSStackFunction {
    public UNBUCKETIZECALENDAR(String name) {
        super(name);
    }

    public UNBUCKETIZECALENDAR() {
        super(UNBUCKETIZECALENDAR.getDefaultName());
    }

    public static String getDefaultName() {
        return "UNBUCKETIZE.CALENDAR";
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        return null;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        if (!BUCKETIZECALENDAR.isDurationBucketized(gts)) {
            throw new WarpScriptException(this.getName() + " expects input GTS to be duration-bucketized. This information is stored in attributes.");
        }
        GeoTimeSerie result = gts.cloneEmpty();
        if (0 == gts.size()) {
            GTSHelper.unbucketize(result);
            result.getMetadata().getAttributes().remove(".bucketduration");
            result.getMetadata().getAttributes().remove(".bucketoffset");
            result.getMetadata().getAttributes().remove(".buckettimezone");
            return result;
        }
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException(this.getName() + " expects input GTS to be bucketized.");
        }
        ADDDURATION.ReadWritablePeriodWithSubSecondOffset bucketperiod = ADDDURATION.durationToPeriod(gts.getMetadata().getAttributes().get(".bucketduration"));
        long bucketoffset = Long.parseLong(gts.getMetadata().getAttributes().get(".bucketoffset"));
        long lastbucketIndex = GTSHelper.lasttick(gts);
        long lastbucket = BUCKETIZECALENDAR.addNonNegativePeriod(0L, bucketperiod, DateTimeZone.UTC, lastbucketIndex + 1L) - 1L - bucketoffset;
        DateTimeZone dtz = DateTimeZone.forID((String)gts.getMetadata().getAttributes().get(".buckettimezone"));
        GTSHelper.unbucketize(result);
        result.getMetadata().getAttributes().remove(".bucketduration");
        result.getMetadata().getAttributes().remove(".bucketoffset");
        result.getMetadata().getAttributes().remove(".buckettimezone");
        for (int i = 0; i < gts.size(); ++i) {
            long tick = BUCKETIZECALENDAR.addNonNegativePeriod(lastbucket, bucketperiod, dtz, i - (gts.size() - 1));
            GTSHelper.setValue(result, tick, GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
        return result;
    }
}

