/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class TOLONGBYTES
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOLONGBYTES(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Long)) throw new WarpScriptException(this.getName() + " operates on a LONG or a list of LONG and expects a number of output bytes per LONG between 1 and 8 on top of the stack.");
        int nbBytes = ((Long)o).intValue();
        o = stack.pop();
        if (o instanceof Long && nbBytes > 0 && nbBytes <= 8) {
            if (8 != nbBytes) {
                stack.push(Arrays.copyOfRange(Longs.toByteArray((long)((Long)o)), 8 - nbBytes, 8));
                return stack;
            } else {
                stack.push(Longs.toByteArray((long)((Long)o)));
            }
            return stack;
        }
        if (!(o instanceof List) || nbBytes <= 0 || nbBytes > 8) throw new WarpScriptException(this.getName() + " operates on a LONG or a list of LONG and expects a number of output bytes per LONG between 1 and 8 on top of the stack.");
        try {
            byte[] b = new byte[nbBytes * ((List)o).size()];
            ByteBuffer bytes = ByteBuffer.wrap(b);
            bytes.order(ByteOrder.BIG_ENDIAN);
            if (8 == nbBytes) {
                for (Object el : (List)o) {
                    bytes.putLong((Long)el);
                }
            } else if (4 == nbBytes) {
                for (Object el : (List)o) {
                    bytes.putInt(((Long)el).intValue());
                }
            } else if (2 == nbBytes) {
                for (Object el : (List)o) {
                    bytes.putShort(((Long)el).shortValue());
                }
            } else if (1 == nbBytes) {
                for (Object el : (List)o) {
                    bytes.put(((Long)el).byteValue());
                }
            } else {
                for (Object el : (List)o) {
                    long v = (Long)el << (8 - nbBytes) * 8;
                    for (int i = 0; i < nbBytes; ++i) {
                        bytes.put((byte)(v >> 56));
                        v <<= 8;
                    }
                }
            }
            stack.push(b);
            return stack;
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " operates on a LONG or a list of LONG and expects a number of output bytes per LONG between 1 and 8 on top of the stack.", e);
        }
    }
}

