/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.json.JsonUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;

public class TOJSON
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOJSON(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        try {
            Long maxJsonSize = (Long)stack.getAttribute("json.size.max");
            boolean strictJSON = Boolean.TRUE.equals(stack.getAttribute("json.strict"));
            boolean prettyJSON = Boolean.TRUE.equals(stack.getAttribute("json.pretty"));
            String json = JsonUtils.objectToJson(o, strictJSON, prettyJSON, (long)maxJsonSize);
            stack.push(json);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed with to convert to JSON.", ioe);
        }
        catch (StackOverflowError soe) {
            throw new WarpScriptException(this.getName() + " failed with to convert to JSON, the structure is too deep or it references itself.", soe);
        }
        return stack;
    }
}

