/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;

public class TOENCODERS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOENCODERS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        GTSDecoder decoder;
        Object top = stack.pop();
        if (!(top instanceof String || top instanceof byte[] || top instanceof GTSEncoder)) {
            throw new WarpScriptException(this.getName() + " operates on a string, byte array or encoder.");
        }
        HashMap<String, GTSEncoder> encoders = new HashMap<String, GTSEncoder>();
        if (top instanceof GTSEncoder) {
            decoder = ((GTSEncoder)top).getUnsafeDecoder(false);
        } else {
            try {
                byte[] bytes = top instanceof String ? OrderPreservingBase64.decode(top.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])top;
                TDeserializer deser = ThriftUtils.getTDeserializer();
                GTSWrapper wrapper = new GTSWrapper();
                deser.deserialize((TBase)wrapper, bytes);
                decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
            }
        }
        try {
            while (decoder.next()) {
                Object value = decoder.getBinaryValue();
                String type = "DOUBLE";
                if (value instanceof String) {
                    type = "STRING";
                } else if (value instanceof Boolean) {
                    type = "BOOLEAN";
                } else if (value instanceof Long) {
                    type = "LONG";
                } else if (value instanceof Double || value instanceof BigDecimal) {
                    type = "DOUBLE";
                } else if (value instanceof byte[]) {
                    type = "BINARY";
                }
                GTSEncoder enc = (GTSEncoder)encoders.get(type);
                if (null == enc) {
                    enc = new GTSEncoder(0L);
                    enc.setMetadata(decoder.getMetadata());
                    encoders.put(type, enc);
                }
                enc.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), value);
            }
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an exception during conversion.", e);
        }
        stack.push(encoders);
        return stack;
    }
}

