/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TIMEMODULO
extends GTSStackFunction {
    private static String MODULO = "modulo";
    private static String LABEL = "label";

    public TIMEMODULO(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object quotientLabel = stack.pop();
        if (!(quotientLabel instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a quotient label name on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(LABEL, (String)quotientLabel);
        Object modulo = stack.pop();
        if (!(modulo instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a LONG modulo under the quotient label name.");
        }
        params.put(MODULO, (Long)modulo);
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        long modulo = (Long)params.get(MODULO);
        String label = (String)params.get(LABEL);
        TreeMap<Long, GeoTimeSerie> output = new TreeMap<Long, GeoTimeSerie>();
        int n = GTSHelper.nvalues(gts);
        for (int i = 0; i < n; ++i) {
            long tick = GTSHelper.tickAtIndex(gts, i);
            long quotient = tick / modulo;
            long remainder = tick % modulo;
            GeoTimeSerie qgts = (GeoTimeSerie)output.get(quotient);
            if (null == qgts) {
                qgts = new GeoTimeSerie();
                qgts.setName(gts.getName());
                qgts.setMetadata(gts.getMetadata());
                qgts.getMetadata().putToLabels(label, Long.toString(quotient));
                output.put(quotient, qgts);
            }
            GTSHelper.setValue(qgts, remainder, GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
        ArrayList result = new ArrayList();
        result.addAll(output.values());
        return result;
    }
}

