/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class SPLIT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SPLIT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        int limit = Integer.MAX_VALUE;
        if (o instanceof Long) {
            limit = Math.toIntExact((Long)o);
            if (limit <= 0) {
                throw new WarpScriptException(this.getName() + " expects the limit to be a strictly positive integer.");
            }
            o = stack.pop();
        }
        if (!(o instanceof String) || 1 != ((String)o).length()) {
            throw new WarpScriptException(this.getName() + " expects a string delimiter of length 1.");
        }
        char delimiter = ((String)o).charAt(0);
        o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a String.");
        }
        stack.push(SPLIT.split((String)o, delimiter, limit));
        return stack;
    }

    public static List<String> split(String input, char delim, int limit) {
        int splits;
        ArrayList<String> l = new ArrayList<String>();
        int offset = 0;
        for (splits = 1; splits < limit; ++splits) {
            int index = input.indexOf(delim, offset);
            if (-1 == index) {
                l.add(input.substring(offset));
                break;
            }
            l.add(input.substring(offset, index));
            offset = index + 1;
        }
        if (splits >= limit) {
            l.add(input.substring(offset));
        }
        return l;
    }
}

