/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GEOPACK;
import io.warp10.script.functions.WRAP;
import io.warp10.script.processing.Pencode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShapeSVG;

public class SNAPSHOT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static ThreadLocal<AtomicInteger> recursionDepth = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    private static List<SnapshotEncoder> encoders = null;
    private static final int MAX_RECURSION_LEVEL = 16;
    private final boolean snapshotSymbols;
    private final boolean toMark;
    private final boolean countbased;
    private final boolean compresswrappers;
    private final boolean pop;
    private final boolean readable;

    public SNAPSHOT(String name, boolean snapshotSymbols, boolean toMark, boolean pop, boolean countbased) {
        this(name, snapshotSymbols, toMark, pop, countbased, true);
    }

    public SNAPSHOT(String name, boolean snapshotSymbols, boolean toMark, boolean pop, boolean countbased, boolean compresswrappers) {
        this(name, snapshotSymbols, toMark, pop, countbased, compresswrappers, false);
    }

    public SNAPSHOT(String name, boolean snapshotSymbols, boolean toMark, boolean pop, boolean countbased, boolean compresswrappers, boolean readable) {
        super(name);
        this.snapshotSymbols = snapshotSymbols;
        this.toMark = toMark;
        this.pop = pop;
        this.countbased = countbased;
        this.compresswrappers = compresswrappers;
        this.readable = readable;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        int lastidx = 0;
        StringBuilder sb = new StringBuilder();
        if (this.countbased) {
            Object top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a number of stack levels to snapshot.");
            }
            lastidx = ((Number)top).intValue() - 1;
            if (lastidx > stack.depth() - 1) {
                lastidx = stack.depth() - 1;
            }
        } else if (!this.toMark) {
            lastidx = stack.depth() - 1;
        } else {
            int i;
            for (i = 0; i < stack.depth() && !(stack.get(i) instanceof WarpScriptStack.Mark); ++i) {
            }
            lastidx = i;
            if (lastidx >= stack.depth()) {
                throw new WarpScriptException(this.getName() + " expects a MARK on the stack.");
            }
        }
        for (int i = lastidx; i >= 0; --i) {
            if (this.toMark && lastidx == i) continue;
            Object o = stack.get(i);
            SNAPSHOT.addElement(this, sb, o, this.readable);
        }
        if (this.snapshotSymbols) {
            for (Map.Entry<String, Object> entry : stack.getSymbolTable().entrySet()) {
                SNAPSHOT.addElement(this, sb, entry.getValue(), this.readable);
                SNAPSHOT.addElement(this, sb, entry.getKey(), this.readable);
                sb.append("STORE");
                sb.append(" ");
            }
            Object[] regs = stack.getRegisters();
            sb.append("CLEARREGS");
            sb.append(" ");
            for (int i = 0; i < regs.length; ++i) {
                if (null == regs[i]) continue;
                SNAPSHOT.addElement(this, sb, regs[i], this.readable);
                sb.append("POPR");
                sb.append(i);
                sb.append(" ");
            }
        }
        if (this.pop) {
            if (stack.depth() - 1 == lastidx) {
                stack.clear();
            } else {
                while (lastidx >= 0) {
                    stack.pop();
                    --lastidx;
                }
            }
        }
        stack.push(sb.toString());
        return stack;
    }

    public static void addElement(StringBuilder sb, Object o) throws WarpScriptException {
        SNAPSHOT.addElement(null, sb, o, false);
    }

    public static void addElement(StringBuilder sb, Object o, boolean readable) throws WarpScriptException {
        SNAPSHOT.addElement(null, sb, o, readable);
    }

    public static void addElement(SNAPSHOT snapshot, StringBuilder sb, Object o) throws WarpScriptException {
        SNAPSHOT.addElement(snapshot, sb, o, false);
    }

    public static void addElement(SNAPSHOT snapshot, StringBuilder sb, Object o, boolean readable) throws WarpScriptException {
        block86: {
            AtomicInteger depth = null;
            try {
                depth = recursionDepth.get();
                if (depth.addAndGet(1) > 16) {
                    throw new WarpScriptException("Recursive data structures exceeded 16 levels.");
                }
                if (null == o) {
                    sb.append("NULL");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof AtomicLong) {
                    sb.append("COUNTER");
                    sb.append(" ");
                    if (0L != ((AtomicLong)o).get()) {
                        sb.append(((AtomicLong)o).get());
                        sb.append(" ");
                        sb.append("COUNTERSET");
                        sb.append(" ");
                    }
                    break block86;
                }
                if (o instanceof BigDecimal) {
                    sb.append(((BigDecimal)o).toString());
                    sb.append(" ");
                    sb.append("->BD");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof Number) {
                    sb.append(o);
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof String) {
                    sb.append("'");
                    if (readable) {
                        SNAPSHOT.appendProcessedString(sb, o.toString());
                    } else {
                        try {
                            sb.append(WarpURLEncoder.encode(o.toString(), StandardCharsets.UTF_8));
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new WarpScriptException(uee);
                        }
                    }
                    sb.append("' ");
                    break block86;
                }
                if (o instanceof Boolean) {
                    if (Boolean.TRUE.equals(o)) {
                        sb.append("true ");
                    } else {
                        sb.append("false ");
                    }
                    break block86;
                }
                if (o instanceof GeoTimeSerie || o instanceof GTSEncoder) {
                    sb.append("'");
                    MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, new Properties());
                    stack.maxLimits();
                    stack.push(o);
                    WRAP w = new WRAP("", false, null == snapshot ? true : snapshot.compresswrappers);
                    w.apply(stack);
                    sb.append(stack.pop());
                    sb.append("' ");
                    if (o instanceof GeoTimeSerie) {
                        sb.append("UNWRAP");
                    } else {
                        sb.append("UNWRAPENCODER");
                    }
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof Vector) {
                    if (readable) {
                        sb.append("[[");
                        sb.append(" ");
                        for (Object oo : (Vector)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, true);
                        }
                        sb.append("]]");
                        sb.append(" ");
                    } else {
                        sb.append("[[]]");
                        sb.append(" ");
                        for (Object oo : (Vector)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, false);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    break block86;
                }
                if (o instanceof List) {
                    if (readable) {
                        sb.append("[");
                        sb.append(" ");
                        for (Object oo : (List)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, true);
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[]");
                        sb.append(" ");
                        for (Object oo : (List)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, false);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    break block86;
                }
                if (o instanceof Set) {
                    if (readable) {
                        sb.append("(");
                        sb.append(" ");
                        for (Object oo : (Set)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, true);
                        }
                        sb.append(")");
                        sb.append(" ");
                    } else {
                        sb.append("()");
                        sb.append(" ");
                        for (Object oo : (Set)o) {
                            SNAPSHOT.addElement(snapshot, sb, oo, false);
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    break block86;
                }
                if (o instanceof Map) {
                    if (readable) {
                        sb.append("{");
                        sb.append(System.lineSeparator());
                        for (Map.Entry entry : ((Map)o).entrySet()) {
                            SNAPSHOT.addElement(snapshot, sb, entry.getKey(), true);
                            SNAPSHOT.addElement(snapshot, sb, entry.getValue(), true);
                            sb.append(System.lineSeparator());
                        }
                        sb.append("}");
                        sb.append(" ");
                    } else {
                        sb.append("{}");
                        sb.append(" ");
                        for (Map.Entry entry : ((Map)o).entrySet()) {
                            SNAPSHOT.addElement(snapshot, sb, entry.getValue(), false);
                            SNAPSHOT.addElement(snapshot, sb, entry.getKey(), false);
                            sb.append("PUT");
                            sb.append(" ");
                        }
                    }
                    break block86;
                }
                if (o instanceof BitSet) {
                    sb.append("'");
                    sb.append(new String(OrderPreservingBase64.encode(((BitSet)o).toByteArray()), StandardCharsets.UTF_8));
                    sb.append("' ");
                    sb.append("OPB64->");
                    sb.append(" ");
                    sb.append("BYTESTOBITS");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof byte[]) {
                    sb.append("'");
                    sb.append(new String(OrderPreservingBase64.encode((byte[])o), StandardCharsets.UTF_8));
                    sb.append("' ");
                    sb.append("OPB64->");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof GeoXPLib.GeoXPShape) {
                    sb.append("'");
                    sb.append(GEOPACK.pack((GeoXPLib.GeoXPShape)o));
                    sb.append("' ");
                    sb.append("GEOUNPACK");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof WarpScriptStack.Mark) {
                    sb.append("MARK");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof Snapshotable) {
                    sb.append(((Snapshotable)o).snapshot());
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof RSAPublicKey) {
                    sb.append("{ 'algorithm' 'RSA' 'exponent' '");
                    sb.append(((RSAPublicKey)o).getPublicExponent());
                    sb.append("' 'modulus' '");
                    sb.append(((RSAPublicKey)o).getModulus());
                    sb.append("' } ");
                    sb.append("RSAPUBLIC");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof RSAPrivateKey) {
                    sb.append("{ 'algorithm' 'RSA' 'exponent' '");
                    sb.append(((RSAPrivateKey)o).getPrivateExponent());
                    sb.append("' 'modulus' '");
                    sb.append(((RSAPrivateKey)o).getModulus());
                    sb.append("' } ");
                    sb.append("RSAPRIVATE");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof PGPPublicKey) {
                    try {
                        SNAPSHOT.addElement(sb, ((PGPPublicKey)o).getEncoded(false));
                    }
                    catch (IOException ioe) {
                        throw new WarpScriptException("Error while serializing PGP public key.", ioe);
                    }
                    sb.append("PGPPUBLIC");
                    sb.append(" ");
                    String keyid = "000000000000000" + Long.toHexString(((PGPPublicKey)o).getKeyID());
                    keyid = keyid.substring(keyid.length() - 16, keyid.length()).toUpperCase();
                    SNAPSHOT.addElement(sb, keyid);
                    sb.append("GET");
                    sb.append(" ");
                    SNAPSHOT.addElement(sb, "key");
                    sb.append("GET");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof PGPSecretKeyRing) {
                    try {
                        SNAPSHOT.addElement(sb, ((PGPSecretKeyRing)o).getEncoded());
                    }
                    catch (IOException ioe) {
                        throw new WarpScriptException("Error while serializing PGP secret key ring.", ioe);
                    }
                    sb.append("PGPRING");
                    sb.append(" 0 ");
                    sb.append("GET");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof PGPPublicKeyRing) {
                    try {
                        SNAPSHOT.addElement(sb, ((PGPPublicKeyRing)o).getEncoded());
                    }
                    catch (IOException ioe) {
                        throw new WarpScriptException("Error while serializing PGP public key ring.", ioe);
                    }
                    sb.append("PGPRING");
                    sb.append(" 0 ");
                    sb.append("GET");
                    sb.append(" ");
                    break block86;
                }
                if (o instanceof NamedWarpScriptFunction) {
                    sb.append(o.toString());
                    sb.append(" ");
                } else if (o instanceof PImage && !(o instanceof PGraphics)) {
                    sb.append("'");
                    sb.append(Pencode.PImageToString((PImage)o, null));
                    sb.append("' ");
                    sb.append("Pdecode");
                    sb.append(" ");
                } else if (o instanceof PShapeSVG) {
                    PShapeSVG pshape = (PShapeSVG)o;
                    try {
                        Field elementField = PShapeSVG.class.getDeclaredField("element");
                        elementField.setAccessible(true);
                        Object element = elementField.get(pshape);
                        sb.append("'");
                        sb.append(element.toString());
                        sb.append("' ");
                        sb.append("PloadShape");
                        sb.append(" ");
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        sb.append("'UNSUPPORTED:" + WarpURLEncoder.encode(o.getClass().toString(), StandardCharsets.UTF_8) + "' ");
                    }
                } else if (o instanceof RealVector) {
                    RealVector vector = (RealVector)o;
                    if (readable) {
                        sb.append("[");
                        sb.append(" ");
                        for (int i = 0; i < vector.getDimension(); ++i) {
                            sb.append(vector.getEntry(i));
                            sb.append(" ");
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[]");
                        sb.append(" ");
                        for (int i = 0; i < vector.getDimension(); ++i) {
                            sb.append(vector.getEntry(i));
                            sb.append(" ");
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    sb.append("->VEC");
                    sb.append(" ");
                } else if (o instanceof RealMatrix) {
                    RealMatrix matrix = (RealMatrix)o;
                    if (readable) {
                        sb.append("[");
                        sb.append(System.lineSeparator());
                        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
                            sb.append("[");
                            sb.append(" ");
                            for (int j = 0; j < matrix.getRowDimension(); ++j) {
                                sb.append(matrix.getEntry(i, j));
                                sb.append(" ");
                            }
                            sb.append("]");
                            sb.append(System.lineSeparator());
                        }
                        sb.append("]");
                        sb.append(" ");
                    } else {
                        sb.append("[]");
                        sb.append(" ");
                        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
                            sb.append("[]");
                            sb.append(" ");
                            for (int j = 0; j < matrix.getRowDimension(); ++j) {
                                sb.append(matrix.getEntry(i, j));
                                sb.append(" ");
                                sb.append("+!");
                                sb.append(" ");
                            }
                            sb.append("+!");
                            sb.append(" ");
                        }
                    }
                    sb.append("->MAT");
                    sb.append(" ");
                } else if (o instanceof Matcher) {
                    sb.append("'");
                    sb.append(((Matcher)o).pattern());
                    sb.append("' ");
                    sb.append("MATCHER");
                    sb.append(" ");
                } else {
                    boolean encoded = false;
                    if (null != encoders) {
                        SnapshotEncoder encoder;
                        Iterator<SnapshotEncoder> iterator = encoders.iterator();
                        while (iterator.hasNext() && !(encoded = (encoder = iterator.next()).addElement(snapshot, sb, o, readable))) {
                        }
                    }
                    if (!encoded) {
                        sb.append("'UNSUPPORTED:" + WarpURLEncoder.encode(o.getClass().toString(), StandardCharsets.UTF_8) + "' ");
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new WarpScriptException(uee);
            }
            finally {
                if (null != depth && 0 == depth.addAndGet(-1)) {
                    recursionDepth.remove();
                }
            }
        }
    }

    public static void appendProcessedString(StringBuilder sb, String s) {
        int i;
        int lastIdx = 0;
        int idx = 0;
        while (idx < s.length()) {
            if ('%' == s.charAt(idx) || '\'' == s.charAt(idx) || s.charAt(idx) < ' ') {
                for (i = 0; i < idx - lastIdx; ++i) {
                    sb.append(s.charAt(lastIdx + i));
                }
                sb.append("%" + (s.charAt(idx) >>> 4) + Integer.toHexString(s.charAt(idx) & 0xF));
                lastIdx = ++idx;
                continue;
            }
            ++idx;
        }
        if (idx > lastIdx) {
            for (i = 0; i < idx - lastIdx; ++i) {
                sb.append(s.charAt(lastIdx + i));
            }
        }
    }

    public static synchronized void addEncoder(SnapshotEncoder encoder) {
        if (null == encoders) {
            encoders = new ArrayList<SnapshotEncoder>();
        }
        encoders.add(encoder);
    }

    public static interface Snapshotable {
        public String snapshot();
    }

    public static interface SnapshotEncoder {
        public boolean addElement(SNAPSHOT var1, StringBuilder var2, Object var3, boolean var4) throws WarpScriptException;
    }
}

